
<!DOCTYPE html>
<html>
	<head>
		<!-- Basic Page Info -->
		<meta charset="utf-8" />
		<title><?php echo $__env->yieldContent('pageTitle'); ?> | Compta App</title>

		<!-- Site favicon -->
		<link
			rel="apple-touch-icon"
			sizes="180x180"
			href="<?php echo e(asset('assets/vendors/images/apple-touch-icon.png')); ?>"
		/>
		<link
			rel="icon"
			type="image/png"
			sizes="32x32"
			href="<?php echo e(asset('assets/vendors/images/favicon-32x32.png')); ?>"
		/>
		<link
			rel="icon"
			type="image/png"
			sizes="16x16"
			href="<?php echo e(asset('assets/vendors/images/favicon-16x16.png')); ?>"
		/>

		<!-- Mobile Specific Metas -->
		<meta
			name="viewport"
			content="width=device-width, initial-scale=1, maximum-scale=1"
		/>

		<!-- Google Font -->
		<link
			href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap"
			rel="stylesheet"
		/>
		<!-- CSS -->
		<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/vendors/styles/core.css')); ?>" />
		<link
			rel="stylesheet"
			type="text/css"
			href="<?php echo e(asset('assets/vendors/styles/icon-font.min.css')); ?>"
		/>
		<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/vendors/styles/style.css')); ?>" />

		
		<script>
			(function (w, d, s, l, i) {
				w[l] = w[l] || [];
				w[l].push({ "gtm.start": new Date().getTime(), event: "gtm.js" });
				var f = d.getElementsByTagName(s)[0],
					j = d.createElement(s),
					dl = l != "dataLayer" ? "&l=" + l : "";
				j.async = true;
				j.src = "https://www.googletagmanager.com/gtm.js?id=" + i + dl;
				f.parentNode.insertBefore(j, f);
			})(window, document, "script", "dataLayer", "GTM-NXZMQSS");
		</script>
		<!-- End Google Tag Manager -->
        <?php echo $__env->yieldPushContent('stylesheets'); ?>
	</head>
	<body class="login-page">
		<div class="login-header box-shadow">
			<div
				class="container-fluid d-flex justify-content-between align-items-center"
			>
				<div class="brand-logo">
					<a href="<?php echo e(route('home')); ?>">
						<img src="<?php echo e(asset('assets/vendors/images/compta-logo.png')); ?>" alt="" />
						
					</a>
				</div>
				
			</div>
		</div>
		<div
			class="login-wrap d-flex align-items-center flex-wrap justify-content-center"
		>
        <div class="container">
				<div class="row align-items-center">
					<div class="col-md-6 col-lg-7">
						<?php if(Route::is('login')): ?>
						 <img src="<?php echo e(asset('assets/vendors/images/login-page-img.png')); ?>" alt="" />
						<?php else: ?>
						 <img src="<?php echo e(asset('assets/vendors/images/forgot-password.png')); ?>" alt="" />
						<?php endif; ?>
					</div>
					<div class="col-md-6 col-lg-5">
						  <?php echo $__env->yieldContent('content'); ?>
					</div>
				</div>
			</div> 
		</div>

		<!-- welcome modal end -->
		<!-- js -->
		<script src="<?php echo e(asset('assets/vendors/scripts/core.js')); ?>"></script>
		<script src="<?php echo e(asset('assets/vendors/scripts/script.min.js')); ?>"></script>
		<script src="<?php echo e(asset('assets/vendors/scripts/process.js')); ?>"></script>
		<script src="<?php echo e(asset('assets/vendors/scripts/layout-settings.js')); ?>"></script>
		<script>
			if(navigator.userAgent.indexOf("Firefox") != -1){
				history.pushState(null, null, document.URL);
				window.addEventLister('popstate',function(){
					history.pushState(null, null, document.URL);
				});
			}
		</script>
		<?php echo $__env->yieldPushContent('scripts'); ?>
	</body>
</html>
<?php /**PATH D:\laravel_apps\big-manager\resources\views/layout/auth-layout.blade.php ENDPATH**/ ?>