<?php

use App\Mail\ResetPassword;
use Illuminate\Support\Str;
use App\Livewire\Administration;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\AdministrationController;
use App\Http\Controllers\LinkController;
use App\Http\Controllers\PlanComptableOhadaController;
use App\Mail\WelcomeMessage;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Auth;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    Auth::logout();
    return to_route('home');
    //return new WelcomeMessage('','') ;
});





/* Route::get('/mail', function () {
    return new ResetPassword('christian');
});*/

/*$token = base64_encode(Str::random(20));
$Tok = strtoupper($token);
$tok = ($token);
$t = substr($Tok, 0, 5).'-'.substr($Tok, 5, 5).'-'.substr($Tok, 10, 5).'-'.substr($Tok, 15, 5);

dd($Tok);*/


//Route::prefix('manager')->name('admin.')->group(function(){

Route::get('/access/{token}', [LinkController::class, 'access'])->name('access');


Route::middleware('guest')->group(function () {
    Route::view('/login', 'pages.auth.login')->name('login');
    Route::view('/forgot-password', 'pages.auth.forgot-password')->name('forgot-password');

    Route::controller(LoginController::class)->group(function () {
        Route::get('/password/reset/{token}', 'resetPassword')->name('reset-password');
        Route::post('/login_handler', 'loginHandler')->name('login_handler');
        Route::post('/send-password-reset-link', 'sendPasswordResetLink')->name('send-password-reset-link');
        Route::post('/reset-password-handler', 'resetPasswordHandler')->name('reset-password-handler');
    });
});

Route::middleware(['auth'])->group(function () {

    Route::get('/homee', function () {
        $pdf = Pdf::loadView('pdf.table_immobilisation', compact('amort_sur', 'amort_date', 'devise', 'affiche_amort', 'dico_immo'));
        return $pdf->download('invoice.pdf');
    });
    Route::view('/home', 'pages.home')->name('home');
    Route::post('/logout_handler', [LoginController::class, 'logoutHandler'])->name('logout_handler');
    Route::view('/setting', 'pages.settings')->name('settings');
    Route::view('/suivi-demande-rens', 'pages.compte_devise')->name('compte-devise');
    Route::view('/tiers', 'pages.tiersView')->name('tiers');
    Route::view('/compte-tiers', 'pages.compte_tiersView')->name('compte-tiers');
    Route::view('/immobilisation', 'pages.immobilisationView')->name('immobilisation');
    Route::view('/saisie-journaux', 'pages.saisieJournauxView')->name('saisie-journaux');
    Route::view('/journaux-comptable', 'pages.journauxComptableView')->name('journaux-comptable');
    Route::view('/etat-financier', 'pages.etatFinancierView')->name('etat-financier');

    Route::view('/saisie/journal-achat', 'pages.saisieJournalAchatView')->name('journal-achat');
    Route::view('/saisie/journal-vente', 'pages.saisieJournalVenteView')->name('journal-vente');
    Route::view('/saisie/journal-od-achat-vente', 'pages.saisieJournalOdAchatVenteView')->name('journal-od-achat-vente');
    Route::view('/saisie/journal-od', 'pages.saisieJournalOdView')->name('journal-od');
    Route::view('/saisie/journal-banque', 'pages.saisieJournalBanqueView')->name('journal-banque');
    Route::view('/saisie/journal-caisse', 'pages.saisieJournalCaisseView')->name('journal-caisse');

    Route::view('/tresorerie/banque', 'pages.tresorerieBanqueView')->name('tresorerie-banque');
    Route::view('/tresorerie/caisse', 'pages.tresorerieCaisseView')->name('tresorerie-caisse');
    Route::view('/parametrage/profil-entreprise', 'pages.settingSocietyView')->name('profil-entreprise');


    Route::view('/demande', 'pages.demandeView')->name('demande');
    Route::get('/profile', [ProfileController::class, 'profileView'])->name('profile');
    Route::view('/administration', 'pages.suiviDemandeView')->name('administration');
    Route::view('/rens', 'pages.rensDemandeView')->name('rens');
    Route::get('/download/{filename}', [FileController::class, 'download'])->name('file.download');
    /* 
        Route::post('/change-profile-picture',[AdminController::class,'changeProfilePicture'])->name('change-profile-picture');
        Route::view('/settings','back.pages.admin.settings')->name('settings');*/

    /*  Route::controller(SiteWebController::class)->group(function(){
            Route::get('/equipe-dirigeante','resetPassword')->name('equipe-dirigeante');
            Route::post('/login_handler','loginHandler')->name('login_handler');
            Route::post('/send-password-reset-link','sendPasswordResetLink')->name('send-password-reset-link');
            Route::post('/reset-password-handler','resetPasswordHandler')->name('reset-password-handler');
        });*/

    Route::prefix('manager')->name('admin.')->group(function () {

        Route::view('/home', 'pages.admin.home')->name('home');
        Route::view('/customer', 'pages.admin.customerView')->name('customer');
        Route::view('/demande', 'pages.admin.suiviDemandeView')->name('demande');
        Route::view('/rens', 'pages.admin.rensDemandeView')->name('rens');
    });
});
