@extends('layout.page-layout')
@section('pageTitle',isset($pageTitle) ? $pageTitle : 'Treso Caisse')

@section('content')

<div class="page-header">
    <div class="row">
        <div class="col-md-6 col-sm-12">
            <div class="title">
                <h4>Caisse</h4>
            </div>
            <nav aria-label="breadcrumb" role="navigation">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="{{ route('home') }}">Home</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        Caisse
                    </li>
                </ol>
            </nav>
        </div>
        
    </div>
</div>

@if(get_current_idWorkDay())


<div class="row">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 mb-30">
        <div class="card-box height-100-p overflow-hidden">
            @livewire('tresorerie-caisse')
        </div>
    </div>
</div>

@else
<div class="alert alert-danger d-flex align-items-center" role="alert">
    <div>
        <i class="icon-copy bi bi-shield-fill-x"></i> Aucun taux de change renseigné !
        &nbsp;
        <a href="{{ route('administration') }}" class="alert-link">définir Taux de change</a>
    </div>
</div>

@endif
@endsection

@push('scripts')
<script>
           window.addEventListener('showConfirmModalTauxChange', event => {
					$('#confirmation_modal_taux_change').modal('show');
				})
            
            window.addEventListener('hideConfirmModalTauxChange', event => {
					$('#confirmation_modal_taux_change').modal('hide');
				})
</script>
    
@endpush

