@extends('layout.page-layout')
@section('pageTitle',isset($pageTitle) ? $pageTitle : 'Administration')

@section('content')

<div class="row mb-3 ">
    <div class="col-md-6 col-sm-12">
        <div class="title">
            <h2 class="h3 mb-0">Administration</h2>
        </div>
    </div>
</div>



@if(getCurrentExercice())

    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 mb-30">
            <div class="card-box height-100-p overflow-hidden">
                @livewire('administration')
            </div>
        </div>
    </div>

@else
<div class="alert alert-danger d-flex align-items-center" role="alert">
    <div>
        <i class="icon-copy bi bi-shield-fill-x"></i> Veuillez faire une configuration initiale  
        &nbsp;
        <a href="{{ route('home') }}" class="alert-link">go to Accueil</a>
    </div>
</div>
@endif

@endsection


@push('scripts')
<script>
           window.addEventListener('showConfirmModalTauxChange', event => {
					$('#confirmation_modal_taux_change').modal('show');
				})
            
            window.addEventListener('hideConfirmModalTauxChange', event => {
					$('#confirmation_modal_taux_change').modal('hide');
				})
            
            window.addEventListener('showConfirmCloturePeriode', event => {
                $('#confirmation_modal_cloture_periode').modal('show');
            })
        
            window.addEventListener('hideConfirmCloturePeriode', event => {
                $('#confirmation_modal_cloture_periode').modal('hide');
            })

            window.addEventListener('showConfirmClotureExercice', event => {
                $('#confirmation_modal_cloture_exercice').modal('show');
            })
        
            window.addEventListener('hideConfirmClotureExercice', event => {
                $('#confirmation_modal_cloture_exercice').modal('hide');
            })
</script>
    
@endpush

