<div>
    
    <div wire:ignore.self
									class="modal fade"
									id="confirmation_modal_achat"
									tabindex="-1"
									role="dialog"
									aria-hidden="true"
                                    data-backdrop="static"
								>
									<div
										class="modal-dialog modal-dialog-centered"
										role="document"
									>
										<div class="modal-content">
											<div class="modal-body text-center font-18">
												<h4 class="padding-top-30 mb-30 weight-500">
													Voulez-vous faire ce changement?
												</h4>
												<div
													class="padding-bottom-30 row"
													style="max-width: 170px; margin: 0 auto"
												>
													<div class="col-6">
														<button
															type="button"
															class="btn btn-secondary border-radius-100 "
															data-dismiss="modal"
														>
															<i class="fa fa-times"></i> Non
														</button>
														
													</div>
													<div class="col-6">
														<button
															type="button"
															class="btn btn-primary border-radius-100 "
															wire:click=""
														>
															<i class="fa fa-check"></i> Oui
														</button>
														
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>



    <div class="profile-tab height-100-p">
        <div class="tab height-100-p">
            <ul class="nav nav-tabs customtab" role="tablist">
                <li class="nav-item">
                    <a wire:click.prevent="selectTab('facture')" class="nav-link {{ $tab == 'facture' ? 'active' : '' }}" data-toggle="tab" href="#timeline" role="tab">Facture : Clients - Fournisseurs</a>
                </li>
                <li class="nav-item">
                    <a wire:click.prevent="selectTab('td')" class="nav-link {{ $tab == 'td' ? 'active' : '' }}" data-toggle="tab" href="#tasks" role="tab">Transactions diverses</a>
                </li>
                
                
            </ul>
            <div class="tab-content">
                <!-- Timeline Tab start -->
                <div class="tab-pane fade {{ $tab == 'facture' ? 'show active' : '' }}" id="timeline" role="tabpanel">
                    <div class="pd-20">
						<div class="row">
							<div class="col-md-12">
							   <form  >

								<div class="row mb-5">
									<div class="col-md-4 px-auto">
										<div class="custom-control custom-radio mb-5">
											<input
												type="radio"
												id="customRadio1"
												name="customRadio"
												class="custom-control-input"
												wire:model.live = "reglement"
												value="singulier"
											/>
											<label class="custom-control-label" for="customRadio1"
											@if($reglement === "singulier") style="color : blue; font-weight:bold;"  @endif
												>Réglement singulier (sur Facture) </label
											>
										</div>
									</div>
									<div class="col-md-1">
										|
									</div>
									<div class="col-md-4">
										<div class="custom-control custom-radio mb-5">
											<input
												type="radio"
												id="customRadio2"
												name="customRadio"
												class="custom-control-input"
												wire:model.live = "reglement"
												value="global"
											/>
											<label class="custom-control-label" for="customRadio2"
												@if($reglement === "global") style="color : blue; font-weight:bold;"  @endif>Réglement global (sur Tiers)</label
											>
										</div>
									</div>
								</div>
								   <div class="row">
										@if($is_singulier)

										<div class="col-md-8">
											<div class="form-group">
												<label for="">Num. Facture</label>
												<input type="text"  id="" class="form-control form-control-sm" wire:model="idFacture" >
												@error('idFacture')
													<small class="form-text text-danger">{{ $message }}</small>
												@enderror
											</div>
										</div>

										

										@else

									

										<div class="col-md-4">
											<div class="form-group">
												<label for="">Tiers</label>
												

												<select 
												class="form-control form-control-sm"
												wire:model.live="idTiers"
														>
													<option value="">select</option>
													<optgroup label="FOURNISSEUR">  
														@foreach(get_tiers('fourn') AS $info )
																<option value="{{ $info->id }}">{{ $info->denomination}} </option>
														@endforeach
													</optgroup>
													<optgroup label="CLIENT">  
														@foreach(get_tiers('client') AS $info )
																<option value="{{ $info->id }}">{{ $info->denomination}} </option>
														@endforeach
													</optgroup>
											</select>

												@error('idTiers')
													<small class="form-text text-danger">{{ $message }}</small>
												@enderror
											</div>
										</div>
										<div class="col-md-4">
											<div class="form-group">
												<label for="">Compte de tiers</label>
										<select 
												class="form-control form-control-sm"
												wire:model.live="CompteTiers" 
												id=""
													>
													<option value="">select</option>
												@if($ListCompte_tiers)
													@foreach($ListCompte_tiers AS $compte )
															<option value="{{ $compte->num_compte }}">{{ $compte->num_compte}} - {{ $compte->nom_compte }}</option>
													@endforeach
												@endif
															
										</select>
												@error('CompteTiers')
													<small class="form-text text-danger">{{ $message }}</small>
												@enderror
											</div>
										</div>

										@endif
									   
									   
									   <div class="col-md-4">
										<div class="form-group">
											<label for="">Compte de banque</label>
											
											<select 
												class="form-control form-control-sm"
												wire:model="CompteBanque_facture" 
												id=""
													>
													<option value="">select</option>
												
													@foreach(get_compte_banque() AS $compte )
															<option value="{{ $compte->num_compte }}">{{ $compte->num_compte}} - {{ $compte->nom_compte }}</option>
													@endforeach
												
															
										</select>
											@error('CompteBanque_facture')
												<small class="form-text text-danger">{{ $message }}</small>
											@enderror
										</div>
									</div>
									   
								   </div>
								   <div class="row">
									   <div class="col-md-8">
										   <div class="form-group">
											   <label for="">Objet</label>
											   <input type="text"  class="form-control form-control-sm" wire:model="libelle_facture" >
											   @error('libelle_facture')
											   		<small class="form-text text-danger">{{ $message }}</small>
											   @enderror
										   </div>
									   </div>
									   <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="">Justification </label>
                                            <input type="text"  class="form-control form-control-sm" wire:model="justification_facture" >
                                            @error('justification_facture')
                                                <small class="form-text text-danger">{{ $message }}</small>
                                            @enderror
                                        </div>
                                    </div>
								   </div>
								   
								   <div class="row">
									   <div class="col-md-3">
										   <div class="form-group">
											   <label for="">Montant</label>
											   <input type="text"  class="form-control form-control-sm" wire:model="montant_facture"   >
											   @error('montant_facture')
											   		<small class="form-text text-danger">{{ $message }}</small>
											   @enderror
										   </div>
									   </div>
									   <div class="col-md-3">
										   <div class="form-group">
											   <label for="">Devise</label>
											   <select class="form-control form-control-sm" wire:model="devise_facture">
												  @foreach ( get_select_devise() as $devise )
													  <option value="{{ $devise->devise }}">{{ $devise->devise}} - {{ $devise->intitule }}</option>
												  @endforeach
											   </select>
											   @error('devise_facture')
											   		<small class="form-text text-danger">{{ $message }}</small>
											   @enderror
										   </div>
									   </div>

									   <div class="col-md-3">
										<div class="form-group">
											<label for="">Date</label>
											<input type="date"  class="form-control form-control-sm" wire:model="date_facture" >
											@error('date_facture')
												<small class="form-text text-danger">{{ $message }}</small>
											@enderror
										</div>
									</div>

									<div class="col-md-3">
										<div class="form-group">
											<label for="">Pièce justificative</label> <small class="text-muted">(.pdf)</small>
											<input type="file"  class="form-control form-control-sm" wire:model="piece_justif" >
											@error('piece_justif')
													<small class="form-text text-danger">{{ $message }}</small>
											@enderror
										</div>
									</div>


								   </div>

								  
									  <button type="button" wire:click="resetForm_Facture" class="btn btn-light">Annuler</button>
									   
									  @if($is_singulier)
										<button type="button" class="btn btn-primary" wire:click="saveTresoBanqueFactureSingulier" > 
											Enregistrer  
										</button>
									  @else
									  	<button type="button" class="btn btn-primary" wire:click="saveTresoBanqueFactureGlobal({{ true }})"> 
												Encaissement   
							   			</button>

							   			<button type="button" class="btn btn-danger" wire:click="saveTresoBanqueFactureGlobal"> 
												Décaissement   
								   		</button>
									  @endif
							   </form>
							</div>
							
						</div>
                    </div>
                </div>
                <!-- Timeline Tab End -->
                <!-- Tasks Tab start -->
                <div class="tab-pane fade {{ $tab == 'td' ? 'show active' : '' }}" id="tasks" role="tabpanel">
                   <div class="pd-20 profile-task-wrap">
					<div class="row">
						<div class="col-md-12">
						   <form  >

							   <div class="row">
									
									<div class="col-md-6">
										<div class="form-group">
											<label for="">Compte</label>
											<input type="text"   class="form-control form-control-sm" wire:model="CompteTiers_td" >
											@error('CompteTiers_td')
												<small class="form-text text-danger">{{ $message }}</small>
											@enderror
										</div>
									</div>

								   <div class="col-md-6">
									<div class="form-group">
										<label for="">Compte de banque</label>
										
										<select 
												class="form-control form-control-sm"
												wire:model="CompteBanque_td" 
												id=""
													>
													<option value="">select</option>
												
													@foreach(get_compte_banque() AS $compte )
															<option value="{{ $compte->num_compte }}">{{ $compte->num_compte}} - {{ $compte->nom_compte }}</option>
													@endforeach
												
															
										</select>
										@error('CompteBanque_td')
												<small class="form-text text-danger">{{ $message }}</small>
										@enderror
									</div>
								</div>
								   
							   </div>
							   <div class="row">
								   <div class="col-md-8">
									   <div class="form-group">
										   <label for="">Objet</label>
										   <input type="text"  class="form-control form-control-sm" wire:model="libelle_td" >
										   @error('libelle_td')
											   <span class="text-danger">{{ $message }}</span>
										   @enderror
									   </div>
								   </div>
								   <div class="col-md-4">
									<div class="form-group">
										<label for="">Justification </label>
										<input type="text"  class="form-control form-control-sm" wire:model="justification_td" >
										@error('justification_td')
											<small class="form-text text-danger">{{ $message }}</small>
										@enderror
									</div>
								</div>
							   </div>
							   
							   <div class="row">
								   <div class="col-md-3">
									   <div class="form-group">
										   <label for="">Montant</label>
										   <input type="text"  class="form-control form-control-sm" wire:model="montant_td"   >
										   @error('montant_td')
										   		<small class="form-text text-danger">{{ $message }}</small>
										   @enderror
									   </div>
								   </div>
								   <div class="col-md-3">
									   <div class="form-group">
										   <label for="">Devise</label>
										   <select class="form-control form-control-sm" wire:model="devise_td">
											  @foreach ( get_select_devise() as $devise )
												  <option value="{{ $devise->devise }}">{{ $devise->devise}} - {{ $devise->intitule }}</option>
											  @endforeach
										   </select>
										   @error('devise_td')
										 		  <small class="form-text text-danger">{{ $message }}</small>	
										   @enderror
									   </div>
								   </div>

								   <div class="col-md-3">
									<div class="form-group">
										<label for="">Date</label>
										<input type="date"  class="form-control form-control-sm" wire:model="date_td" >
										@error('date_td')
												<small class="form-text text-danger">{{ $message }}</small>
										@enderror
									</div>
								</div>

								<div class="col-md-3">
									<div class="form-group">
										<label for="">Pièce justificative</label> <small class="text-muted">(.pdf)</small>
										<input type="file"  class="form-control form-control-sm" wire:model="piece_justif_td" >
										@error('piece_justif_td')
											<small class="form-text text-danger">{{ $message }}</small>
										@enderror
									</div>
								</div>

							   </div>

		
								  <button type="button" wire:click="resetForm_TD" class="btn btn-light">Annuler</button>
									  <button type="button" class="btn btn-primary" wire:click="saveTresoBanqueTD({{ true }})"> 
											Encaissement   
									   </button>

									   <button type="button" class="btn btn-danger" wire:click="saveTresoBanqueTD"> 
											Décaissement   
									   </button>
						   </form>
						</div>
						
					</div>
                   </div>
                </div>
                <!-- Tasks Tab End -->
                

            </div>  
        </div>
    </div>

</div>



@push('scripts')
<script>
	window.addEventListener('resetSelect_Tiers_od', event => {
                     $("#Select_tiers").select2().val(event.detail.data).trigger('change');
				})
    $('#Select_tiers').select2({
        placeholder: {
                            id: "", // the value of the option
                            text: 'Select Tiers'
                    },
        allowClear: true
    });
    $('#Select_tiers').on('change',function(e){
        var data = $(this).select2('val');
        @this.set('idFournisseur_od',data);
    });

</script>
@endpush
