
<div >



    <div  wire:ignore.self
    class="modal fade bs-example-modal-lg"
    id="DetailTransactionModal"
    tabindex="-1"
    role="dialog"
    aria-labelledby="TransactionModal"
    aria-hidden="true"
>
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="TransactionModal">
                    Détails
                </h4>
                <button
                    type="button"
                    class="close"
                    data-dismiss="modal"
                    aria-hidden="true"
                >
                    ×
                </button>
            </div>
            <div class="modal-body">
                @php
                    $n = ($is_facture) ? 7 : 5 ;
                @endphp
                <div class="table-responsive">
                    <table  class="table-sm table-striped" style="width:100%; font-size:15px;">
                        <thead>
                            <tr>
                                <th colspan="{{ $n }}">{{ $this->title_detail }}</th>
                            </tr>
                            @if($list_data_detail)

                                @if($is_facture)
                                    <tr>
                                        <td >Dénomination</td>
                                        <td >Date</td>
                                        <td >Libellé</td>
                                        <td >N° Facture</td>
                                        <td align="right">Montant</td>
                                        <td align="right"> Solde</td>
                                        <td >Devise</td>
                                    </tr>
                                @else
                                    <tr>
                                        <td >Compte</td>
                                        <td >Intitulé</td>
                                        <td align="right">Débit</td>
                                        <td align="right"> Crédit</td>
                                        <td >Devise</td>
                                    </tr>
                                @endif
                            @endif
                        </thead>
                        <tbody>
                           
                            @forelse($list_data_detail as $data )

                                @if($is_facture)
                                    <tr>
                                        <td >{{ $data->denomination }}</td>
                                        <td >{{ get_format_date($data->date_facture) }}</td>
                                        <td >{{ $data->intitule }}</td>
                                        <td>{{ $data->num_facture }}</td>
                                        <td align="right">{{ get_format_montant($data->montant) }}</td>
                                        <td align="right">{{ get_format_montant($data->solde) }}</td> 
                                        <td>{{ $data->devise }}</td>
                                    </tr>
                                @else
                                    <tr>
                                        <td >{{ $data->fk_num_compte }}</td>
                                        <td>{{ $data->nom_compte }}</td>
                                        <td align="right">{{ get_format_montant($data->debit) }}</td>
                                        <td align="right">{{ get_format_montant($data->credit) }}</td> 
                                        <td>{{ $data->devise }}</td>
                                    </tr>
                                @endif
                            @empty
                                <tr>
                                    <td colspan="5" align="center">Aucune donnée trouvée</td>
                                </tr>
                            @endforelse
                            
                            
                        </tbody>
                    </table>
                </div>
            </div>
<div class="modal-footer">
    <button
        type="button"
        class="btn btn-secondary"
        data-dismiss="modal"
    >
         Close
    </button>
</div>
</div>
</div>
</div>


    <form >
        <div class="row mb-1">
            <div class="col-md-4">
                {{ $type_journal }} 
            </div>
            <div class="col-md-3">
                    <input type="date"  class="form-control form-control-sm @error('date_start') form-control-danger @enderror" wire:model="date_start" >
            </div>
            <div class="col-md-3">
                    <input type="date"  class="form-control form-control-sm @error('date_end') form-control-danger @enderror" wire:model="date_end" >
            </div>
            <div class="col-md-2">
                
                    <button type="button" wire:click="doSearch"  class=" bt-sm" style="width:100%; height:30px; "> 
                       recherche
                    </button>
               
            </div>
        </div>
    </form>
   
    <div class="row"> 
 
         <div class="col-md-1">
             <div class="input-group custom ">
                 <select wire:model.live="ligne"   class="form-control form-control-sm"  >
                     <option value="10">10</option>
                     <option value="25">25</option>
                     <option value="50">50</option>
                     <option value="75">75</option>
                     <option value="100">100</option>
                 </select>
             </div>
         </div>
         <div class="col-md-6 offset-md-5">
             <div class="input-group custom ">
                     <input
                         type="text"
                         class="form-control form-control-sm"
                         placeholder="recherche"
                         id="_filter"
                         wire:model.live="search"
                     />
                     <div class="input-group-append custom">
                         <span class="input-group-text"
                             ><i class="icon-copy dw dw-search"></i
                         ></span>
                     </div>
             </div>
         </div>
     </div>
 
     <div  class="table-responsive">
     <table id="table" class="table-striped mb-2" border="1" style="width:100%; font-size:15px;">
         
         <thead>
            @if($group == 'av')
            <tr>
                <th scope="col">Date</th>
                <th scope="col">Libellé</th>
                <th scope="col">Dénomination</th>
                <th scope="col">Num Facture</th>
                <th scope="col">Montant</th>
                <th scope="col"></th>
            </tr>
            @endif

            @if($group == 'bc')
            <tr>
                <th scope="col">Date</th>
                <th scope="col">Libellé</th>
                <th scope="col">Montant</th>
                <th scope="col">Devise</th>
                <th scope="col">Dénomination</th>
                <th scope="col"></th>
            </tr>
            @endif

            @if($group == 'od')
            <tr>
                <th scope="col">Date</th>
                <th scope="col">Libellé</th>
                <th scope="col">Montant</th>
                <th scope="col">Devise</th>
                <th scope="col">Justification</th>
                <th scope="col"></th>
            </tr>
            @endif
         </thead>
         <tbody>
             @php
                 $n = 1;
             @endphp
                 @forelse($list_data as $data )

                 @if($group == 'av')
                     <tr>
                         <td >{{ get_format_date($data->date_valeur) }}</td>
                         <td>{{ $data->intitule }}</td>
                         <td>{{ $data->denomination }}</td>
                         <td>{{ $data->num_facture }}</td> 
                         <td align="right" class="pr-1">{{ get_format_montant($data->montant) }} {{ $data->devise }}</td>
                         <td align="center"><a class="text-primary" style="cursor:pointer;"
                         wire:click="showDetail({{ $data->id }})" ><i class="dw dw-eye"></i> show</a
                         ></td>
                     </tr>
                 @endif


                 @if($group == 'bc')
                     <tr>
                         <td >{{ get_format_date($data->date_valeur) }}</td>
                         <td>{{ $data->intitule }}</td>
                         <td>{{ get_format_montant($data->montant) }}</td>
                         <td>{{ $data->devise }}</td>
                         <td>{{ $data->denomination }}</td>
                         <td><a class="text-primary" style="cursor:pointer;"
                         wire:click="showDetail({{ $data->id }})" ><i class="dw dw-eye"></i> show</a
                         ></td>
                     </tr>
                 @endif

                 @if($group == 'od')
                     <tr>
                         <td >{{ get_format_date($data->date_valeur) }}</td>
                         <td>{{ $data->intitule }}</td>
                         <td>{{ get_format_montant($data->montant) }}</td>
                         <td>{{ $data->devise }}</td>
                         <td>{{ $data->justification }}</td>
                         <td><a class="text-primary" style="cursor:pointer;"
                         wire:click="showDetail({{ $data->id }})" ><i class="dw dw-eye"></i> show</a
                         ></td>
                     </tr>
                 @endif
 
             @empty
                 <tr>
                    <td colspan="7" align="center" class="text-danger">Aucune donnée trouvée pour la periode allant de 
                                    <b>{{ get_format_date($date_start,"L") }}</b> au 
                                    <b>{{ get_format_date($date_end,"L") }}</b>
                    </td>
                 </tr>
             @endforelse
             
                
             
         </tbody>
         
     </table>
     {{ $list_data->links() }}
     </div>
 </div>
 