<div class="pd-20 card-box">
    <form enctype="multipart/form-data" >
        <div class="row">
          <div class="col-md-6">
            {{ $total_achat }}
                 <div class="row mb-2">
                     <div class="col-md-6">
                        
                             <label for="">Date <span style="color:red;">*</span></label>
                             <input type="date"  class="form-control form-control-sm" wire:model="date_achat" tabindex="1" maxlength="50" >
                             @error('date_achat')
                                 <small class="form-text text-danger">{{ $message }}</small>
                             @enderror
                         
                     </div>
                     <div class="col-md-6">
                         
                             <label for="">Justification</label>
                             <input type="text"  class="form-control form-control-sm" wire:model="piece_justif" tabindex="2" maxlength="50"   >
                             @error('piece_justif')
                                 <small class="form-text text-danger">{{ $message }}</small>
                             @enderror
                         
                     </div>
                     </div>

               
                     <div class=" row mb-2">
                         <div class="col-md-12">
                            
                                 <label for="">Libellé<span style="color:red;">*</span></label>
                                 <input type="text"  class="form-control form-control-sm" wire:model="libelle_achat" tabindex="5" maxlength="150"   >
                                 @error('libelle_achat')
                                     <small class="form-text text-danger">{{ $message }}</small>
                                 @enderror
                             
                         </div>
                     </div>

             
             
            
                 <div class="row mb-3">
                     <div class="col-md-5">
                         
                             <label for="">Compte</label>
                             
                             <input type="text"  class="form-control form-control-sm" wire:model="compte_achat" maxlength="8"  tabindex="9">
                             
                             @error('compte_achat')
                                 <small class="form-text text-danger">{{ $message }}</small>
                             @enderror
                             
                         
                        
                     </div>
                     <div class="col-md-3">
                         
                             <label for="">Débit</label>
                             <input type="text"  class="form-control form-control-sm" wire:model="debit_achat" wire:keydown.enter="addItemby"
                             tabindex="10" maxlength="20"
                             >
                             @error('debit_achat')
                                 <small class="form-text text-danger">{{ $message }}</small>
                             @enderror
                         
                     </div>
                     <div class="col-md-3">
                         
                             <label for="">Crédit</label>
                             <input type="text"  class="form-control form-control-sm" wire:model="credit_achat" wire:keydown.enter="addItemby"
                             tabindex="11" maxlength="20"
                             >
                             @error('credit_achat')
                                 <small class="form-text text-danger">{{ $message }}</small>
                             @enderror
                         
                     </div>
                     <div class="col-md-1 ">
                         <div class="row " style="padding-top: 38px;">
                             
                             <span class="badge  badge-primary" wire:click="addItem_achat" style="cursor:pointer;" title="Ajouter" >
                                
                                 <i class="icon-copy fa fa-check" ></i>
                             </span> 
                             &nbsp;&nbsp;
                            
                         </div>
                     </div>
                 </div>

                 <div class="row">

                     <div class="col-md-8 offset-md-2">
       

                         @error('MyArray_achat')
                         <table border="0" class="table-striped table-sm" style="font-size:0.8em; width:100%;">
                             <thead>
                                 <tr>
                                     <td>compte</td>
                                     <td >débit</td>
                                     <td >crédit</td>
                                    
                                 </tr>
                             </thead>    
                             <tbody>
                                 <tr>
                                     <td colspan="3" align="center"  class="text-danger" >
                                             {{ $message }}
                                     </td>
                                 </tr>
                             </tbody>
                         </table>
                         @enderror
                     </div>

                 </div>
            
                   
          </div>
          <div class="col-md-6">
             <div class="row mb-3">
                 <div class="col-md-6">
                     
                 
                        <label for="">Pièce justificative</label> <small class="text-muted">(.pdf)</small>
                        <input type="file"  class="form-control form-control-sm" wire:model="file_piece_justif" accept=".pdf" placeholder="attachez pdf">
                        @error('file_piece_justif')
                            <small class="form-text text-danger">{{ $message }}</small>
                        @enderror
            
             
                 </div>

                 <div class="col-md-6">
                     
                         <label for="">Devise <span style="color:red;">*</span></label>
                         <select class="form-control form-control-sm" wire:model="devise_achat" tabindex="4">
                            @foreach ( get_select_devise() as $devise )
                                <option value="{{ $devise->devise }}">{{ $devise->devise}} - {{ $devise->intitule }}</option>
                            @endforeach
                         </select>
                         @error('devise_achat')
                             <small class="form-text text-danger">{{ $message }}</small>
                         @enderror
                     
                 </div>
             </div>

             <div class="row mx-1" style="border: 1px solid #ABB2B9; height: 220px; position:relative;">
                <div style="width: 100%; height: 180px;overflow: auto;">
                          
                     @empty($MyArray_achat)
                          
                     @else
                         <table border="0" class="table-striped table-sm" style="font-size:0.8em; width:100%;">
                         <thead>
                             <tr style="font-weight: 600;">
                                 <td>compte</td>
                                 <td>intitulé de compte</td>
                                 <td align="right">débit</td>
                                 <td align="right">crédit</td>
                                 <td></td>
                             </tr>
                         </thead>    
                         <tbody>
                             @foreach ( $MyArray_achat as  $data )
                             
                                 <tr>
                                     <td>{{ $data['compte'] }}</td>
                                     <td>{{ $data['intitule'] }}</td>
                                     <td align="right"> @if($data['debit'] == 0) {{ '' }}  @else {{ get_format_montant($data['debit']) }} @endif </td>
                                     <td align="right">@if($data['credit'] == 0) {{ '' }}  @else {{ get_format_montant($data['credit']) }} @endif </td>
                                     <td align="center" ><span class="text-danger"  wire:click="removeItem_achat({{ $data['compte'] }})"  style="cursor:pointer;"><i class="fa fa-times"></i></span></td>
                                 </tr>
                             @endforeach

                             
                         </tbody>
                         </table>
                     @endempty
                 </div>
                 
                 <div class="py-1" style="height:40px;border: 0px solid red; position:absolute;
                 bottom:0;width:100%; display:flex; justify-content:space-around;background-color:@if($isEgal_achat) #1D8348 @else #EAECEE @endif">
                    <span style="font-size:0.8em;">
                     Débit : <strong style="font-size:1.3em;font-weight:700;color:@if($isEgal_achat) white @else '' @endif;">{{ get_format_montant($total_debit) }}</strong></span>  
                    <span class="py-1">|</span> 
                    <span style="font-size:0.8em;">
                     Crédit : <strong style="font-size:1.3em;font-weight:700;color:@if($isEgal_achat) white @else '' @endif;">{{ get_format_montant($total_credit) }}</strong></span> 
                 </div>
             </div>

          </div>
         
        </div>
        <div class="row zone_btn mt-2">
                 <button type="button" wire:click="resetForm_achat" class="btn btn-light btn-sm">Annuler</button>
                             
                 <button type="button" class="btn btn-primary btn-sm" wire:click="saveAchat" wire:loading.attr="disabled" style="width:15%;" @if(!$isEgal_achat) disabled @endif> 
                         
                         <div class="spinner-border spinner-border-sm"  role="status" wire:loading wire:target="saveAchat">
                             <span class="visually-hidden"></span>
                         </div>
         
                         <div wire:loading.remove wire:target="saveAchat">
                             Enregistrer 
                         </div>
                     
                 </button>

         
                 <button type="button" wire:click="goToJournalCompta" class="btn btn-outline-success btn-sm">Apercu Journal</button>
                 
        </div>
     </form>
</div>