<div wire:ignore.self
class="modal fade bs-example-modal-lg"
id="ModalImmo"
tabindex="-1"
role="dialog"
data-backdrop="static"
aria-labelledby="Modal_immo"
aria-hidden="true"
>
<div class="modal-dialog modal-lg modal-dialog-top">
    <div class="modal-content">
        <div class="modal-header">
            <h6 class="modal-title" id="Modal_immo">
                @if($isNewImmo) Ajouter @else Mise à jour @endif Immobilisation
            </h6>
            <button
                type="button"
                class="close"
                wire:click.prevent="CloseModalImmo"
                data-dismiss="modal"
                aria-hidden="true"
            >
                ×
            </button>
        </div>
        <form method="POST"  action="">
        <div class="modal-body">
     
        
        <div class="row">
            <div class="col-md-9">
                <div class="form-group"  wire:ignore>
                    <label for="">Compte <span style="color:red;">*</span></label>
                    <select 
								class="form-control form-control-sm"
								style="width: 100%; height: 50px;"
                                id="Select_Compte"
										>
                                    <option value="">select</option>
                                @foreach(get_compte_immo() AS $immo )
                                        <option value="{{ $immo->num_compte }}">{{ $immo->num_compte}} - {{ $immo->nom_compte }}</option>
                                @endforeach
											
					</select>
                    
                   
                </div>
                @error('compte')
                  <small class="form-text text-danger">{{ $message }}</small>
                @enderror
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label for="">Date d'acquisition <span style="color:red;">*</span></label>
                    <input type="date"  class="form-control form-control-sm" wire:model="date_acq" >
                    @error('date_acq')
                    <small class="form-text text-danger">{{ $message }}</small>
                    @enderror
                </div>
            </div>
        </div>
        <div class="row mb-2">
            <div class="col-md-12">
                
                    <label for="">Libellé <span style="color:red;">*</span></label>
                    <input type="text"  class="form-control form-control-sm" wire:model="libelle" >
                    @error('libelle')
                        <small class="form-text text-danger">{{ $message }}</small>
                    @enderror
                
            </div>
        </div>
        <div class="row mb-2">
            <div class="col-md-3">
                
                    <label for="">Montant <span style="color:red;">*</span></label>
                    <input type="text"  class="form-control form-control-sm" wire:model.live="montant"  >
                    @error('montant')
                         <small class="form-text text-danger">{{ $message }}</small>
                    @enderror
                
            </div>
          
            <div class="col-md-3">
                
                    <label for="">Devise <span style="color:red;">*</span></label>
                    <select class="form-control form-control-sm" wire:model="devise">
                       @foreach ( get_select_devise() as $devise )
                           <option value="{{ $devise->devise }}">{{ $devise->devise}} - {{ $devise->intitule }}</option>
                       @endforeach
                    </select>
                    @error('devise')
                          <small class="form-text text-danger">{{ $message }}</small>
                    @enderror
                
            </div>
            <div class="col-md-3">
                
                    <label for="">Amortir sur  <span style="color:red;">*</span> </label> <small class="text-muted">(par ans)</small>
                        <input type="text"  class="form-control form-control-sm" wire:model.live="periode" >
                    @error('periode')
                      <small class="form-text text-danger">{{ $message }}</small>
                    @enderror
                
            </div>
            <div class="col-md-3">
                
                    <label for="">Amortissement/jour</label>
                    <input type="text" name="phone" id="" class="form-control form-control-sm" wire:model="amortissement" readonly>
                    @error('amortissement')
                         <small class="form-text text-danger">{{ $message }}</small>
                    @enderror
            
            </div>
        </div>
        
        </div>
        <div class="modal-footer">
            <button
                type="button"
                wire:click.prevent="CloseModalImmo"
                class="btn btn-secondary btn-sm"
                data-dismiss="modal"
               
            >
                Fermer
            </button>

        
            @if($isNewImmo)
                    <button type="button" class="btn btn-info btn-sm" wire:click="saveAndCloseModalImmo"
                    wire:loading.attr="disabled" style="width: 25%;"
                    >
                        <div class="spinner-border spinner-border-sm"  role="status" wire:loading wire:target="saveAndCloseModalImmo">
                            <span class="visually-hidden"></span>
                        </div>
        
                        <div wire:loading.remove wire:target="saveAndCloseModalImmo">
                             Enregistrer & Fermer
                        </div>
                    </button>
                    <button type="button" class="btn btn-primary btn-sm" wire:click="saveImmo"
                    wire:loading.attr="disabled" style="width: 15%;"
                    >
                        <div class="spinner-border spinner-border-sm"  role="status" wire:loading wire:target="saveImmo">
                            <span class="visually-hidden"></span>
                        </div>
        
                        <div wire:loading.remove wire:target="saveImmo">
                             Enregistrer 
                        </div>
                    </button>
            @elseif(!$isNewImmo)
                <button type="button" class="btn btn-success btn-sm" wire:click="saveAndCloseModalImmo"
                wire:loading.attr="disabled" style="width: 15%;"
                >
                    <div class="spinner-border spinner-border-sm"  role="status" wire:loading wire:target="saveAndCloseModalImmo">
                        <span class="visually-hidden"></span>
                    </div>
    
                    <div wire:loading.remove wire:target="saveAndCloseModalImmo">
                         Enregistrer 
                    </div>
                </button>
            @else

            @endif

            
            
        </div>
    </form>
    </div>
</div>
</div>

@push('scripts')

<script>
    	window.addEventListener('hideModalImmo', event => {
					$('#ModalImmo').modal('hide');
				})

        window.addEventListener('showModalImmo', event => {
					$('#ModalImmo').modal('show');
				})
  

        window.addEventListener('resetSelect_Compte', event => {
                    // $('#Select_Compte').select2('val',"408000");
                    // $('#Select_Compte').val('408000') ;
                     $("#Select_Compte").select2().val(event.detail.data).trigger('change');
				})

                $(document).ready(function(){
                    $('#Select_Compte').select2({
                        placeholder: {
                            id: "", // the value of the option
                            text: 'Select Compte'
                        },
                        allowClear: true
                    });
                    $('#Select_Compte').on('change',function(e){
                        var data = $('#Select_Compte').select2('val');
                        @this.set('compte',data);
                    });
            });
</script>
    
@endpush

