<div wire:ignore.self
class="modal fade bs-example-modal-lg"
id="ModalApercuJournal"
tabindex="-1"
role="dialog"
data-backdrop="static"
aria-labelledby="Modal_ApJournal"
aria-hidden="true"
>
<div class="modal-dialog modal-lg modal-dialog-top">
    <div class="modal-content">
        <div class="modal-header">
            <h6 class="modal-title" id="Modal_ApJournal">
                {{ $this->title }}
            </h6>
            <button
                type="button"
                class="close"
                wire:click.prevent="CloseModalApJournal"
                data-dismiss="modal"
                aria-hidden="true"
            >
                ×
            </button>
        </div>
        <div class="modal-body">

            <div class="row">
                <div class="col-md-2">
                    <div class="input-group custom ">
                        <select wire:model.live="ligne"   class="form-control form-control-sm"  >
                            <option value="10">10</option>
                            <option value="5">25</option>
                            <option value="50">50</option>
                            <option value="75">75</option>
                            <option value="100">100</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3 offset-md-2">
                        <input type="date"  class="form-control form-control-sm @error('date_start') form-control-danger @enderror" wire:model="date_start" >
                </div>
                <div class="col-md-3">
                        <input type="date"  class="form-control form-control-sm @error('date_end') form-control-danger @enderror" wire:model="date_end" >
                </div>
                <div class="col-md-2">
                    
                        <button type="button"  wire:click="searchJC"  class="btn btn-primary btn-sm" > 
                           recherche
                        </button>
                   
                </div>
            </div>
    <div class="table-responsive">
        <table id="table" class="table-striped mb-2" border="1" style="width:100%; font-size:0.8rem;">
            <thead>
                
                @if($list_data)

                    @if($group == 'av')
                    <tr>
                        <th class="pl-1" style="width: 11%;">Date</th>
                        <th class="pl-1" style="width: 10%;">Référence</th>
                        <th class="pl-1" style="width: 10%;">N° Facture</th>
                        <th class="pl-1" >Libellé</th>
                        <th class="pl-1" >Désignation</th>
                        <th class="pl-1" >Montant</th>
                        <th  style="width: 6%;">Devise</th>
                       <!--  <th ></th> -->
                    </tr>
                    @endif

                    @if($group == 'bc')
                    <tr>
                        <th scope="col">Date</th>
                        <th scope="col">Libellé</th>
                        <th scope="col">Montant</th>
                        <th scope="col">Devise</th>
                        <th scope="col">Désignation</th>
                        <th scope="col"></th>
                    </tr>
                    @endif

                    @if($group == 'od')
                    <tr>
                        <th scope="col">Date</th>
                        <th scope="col">Libellé</th>
                        <th scope="col">Montant</th>
                        <th scope="col">Devise</th>
                        <th scope="col">Justification</th>
                        <th scope="col"></th>
                    </tr>
                    @endif

                @endif
            </thead>
            <tbody>
               
                @forelse($list_data as $data )

                    @if($group == 'av')
                        <tr>
                            <td class="pl-1" >{{ get_format_date($data->date_valeur) }}</td>
                            <td class="pl-1">{{ $data->num_facture }}</td> 
                            <td class="pl-1">{{ $data->num_facture }}</td> 
                            <td class="pl-1">{{ $data->intitule }}</td>
                            <td class="pl-1">{{ $data->denomination }}</td>
                            <td align="right">{{ get_format_montant($data->montant) }}</td>
                            <td align="center">{{ $data->devise }}</td>
                           <!--  <td><a class="text-primary" style="cursor:pointer;"
                            wire:click="showDetail({{ $data->id }})" ><i class="dw dw-eye"></i> show</a
                            ></td> -->
                        </tr>
                    @endif


                    @if($group == 'bc')
                        <tr>
                            <td class="pl-1" >{{ get_format_date($data->date_valeur) }}</td>
                            <td class="pl-1">{{ $data->intitule }}</td>
                            <td class="pl-1">{{ get_format_montant($data->montant) }}</td>
                            <td>{{ $data->devise }}</td>
                            <td>{{ $data->denomination }}</td>
                            <td><a class="text-primary" style="cursor:pointer;"
                            wire:click="showDetail({{ $data->id }})" ><i class="dw dw-eye"></i> show</a
                            ></td>
                        </tr>
                    @endif

                    @if($group == 'od')
                        <tr>
                            <td >{{ get_format_date($data->date_valeur) }}</td>
                            <td>{{ $data->intitule }}</td>
                            <td>{{ get_format_montant($data->montant) }}</td>
                            <td>{{ $data->devise }}</td>
                            <td>{{ $data->justification }}</td>
                            <td><a class="text-primary" style="cursor:pointer;"
                            wire:click="showDetail({{ $data->id }})" ><i class="dw dw-eye"></i> show</a
                            ></td>
                        </tr>
                    @endif
    
                @empty
                    <tr>
                        <td colspan="7" align="center">Aucune donnée trouvée</td>
                    </tr>
                @endforelse
                
                
            </tbody>
        </table>
        {{ $list_data->links() }}
    </div>
            

        </div>
        <div class="modal-footer">
            <button
                type="button"
                wire:click.prevent="CloseModalApJournal"
                class="btn btn-secondary btn-sm"
                data-dismiss="modal"
               
            >
                Fermer
            </button>
        </div>
    </div>
</div>
</div>

@push('scripts')

<script>
    	window.addEventListener('hideModalApercuJournal', event => {
					$('#ModalApercuJournal').modal('hide');
				})

        window.addEventListener('showModalApercuJournal', event => {
					$('#ModalApercuJournal').modal('show');
				})
  
</script>
    
@endpush

