<div>
    <form wire:submit.prevent="searchJournal()" >
        <div class="row">
            <div class="col-md-2">
               
                    <select wire:model.live="ligne"   class="form-control form-control-sm" style="width: 50%;"  >
                        <option value="10">10</option>
                        <option value="25">25</option>
                        <option value="50">50</option>
                        <option value="75">75</option>
                        <option value="100">100</option>
                    </select>

            </div>
            <div class="col-md-2">
                    <select class="form-control form-control-sm" wire:model="journal">
                        <option value="achat">Achat</option>
                        <option value="vente">Vente</option>
                        <option value="banque">Banque</option>
                        <option value="caisse">Caisse</option>
                        <option value="od_av">OD Achats - Ventes</option>
                        <option value="od">Operation Diverses</option>
                    </select>
                    @error('journal')
                    <small class="form-text text-danger">{{ $message }}</small>
                    @enderror
                
            </div>
            <div class="col-md-2">
                
                    <input type="date"  class="form-control form-control-sm" wire:model="date_start" >
                    @error('date_start')
                    <small class="form-text text-danger">{{ $message }}</small>
                    @enderror
                
            </div>
            <div class="col-md-2">
                
                   
                    <input type="date"  class="form-control form-control-sm" wire:model="date_end" >
                    @error('date_end')
                    <small class="form-text text-danger">{{ $message }}</small>
                    @enderror
                
            </div>
            <div class="col-md-2">
                
                    <button type="button" wire:click="searchJournal" wire:loading.attr="disabled" class="btn btn-primary btn-sm" style="width: 80%;"> 
                        
                        <div class="spinner-border spinner-border-sm"  role="status" wire:loading wire:target="searchJournal">
                            <span class="visually-hidden"></span>
                        </div>
        
                        <div wire:loading.remove wire:target="searchJournal">
                            Afficher 
                        </div>
                    </button>
                
            </div>
            <div class="col-md-2">
             
                    <button type="button" wire:click="OpenSaisieJournal" class="btn btn-outline-primary btn-sm" > 
                        Saisie journal
                    </button>
            
            </div>
        </div>
    </form>

    <hr>

    <div class="table-responsive">
        <table id="table" class="table-striped mb-2" border="1" style="width:100%; font-size:0.8rem;">
            <thead>
                
                @if($list_data)

                    @if($group == 'av')
                    <tr>
                        <th class="pl-1" style="width: 10%;">Date</th>
                        <th class="pl-1" style="width: 10%;">Référence</th>
                        <th class="pl-1" >Libellé</th>
                        <th class="pl-1" >Désignation</th>
                        <td align="center" style="width: 15%;" ><b>Montant</b></td>
                        <td align="center" style="width: 6%;" ><b>Devise</b></td>
                        <th align="center" style="width: 8%;"></th>
                    </tr>
                    @endif

                    @if($group == 'bc')
                    <tr>
                        <th class="pl-1" style="width: 10%;">Date</th>
                        <th class="pl-1">Libellé</th>
                        <th class="pl-1">Désignation</th>
                        <td align="center" style="width: 15%;" ><b>Montant</b></td>
                        <td align="center" style="width: 6%;" ><b>Devise</b></td>
                        <th align="center" style="width: 8%;"></th>
                    </tr>
                    @endif

                    @if($group == 'od_av')
                    <tr>
                        <th class="pl-1" style="width: 10%;">Date</th>
                        <th class="pl-1">Libellé</th>
                        <th class="pl-1">Désignation</th>
                        <th class="pl-1">Justification</th>
                        <td align="center" style="width: 15%;" ><b>Montant</b></td>
                        <td align="center" style="width: 6%;" ><b>Devise</b></td>
                        <td align="center" style="width: 50%;" ><b></b></td>
                        <th align="center" style="width: 8%;"></th>
                    </tr>
                    @endif

                    @if($group == 'od')
                    <tr>
                        <th class="pl-1" style="width: 10%;">Date</th>
                        <th class="pl-1">Libellé</th>
                        <th class="pl-1">Justification</th>
                        <td align="center" style="width: 15%;" ><b>Montant</b></td>
                        <td align="center" style="width: 6%;" ><b>Devise</b></td>
                        <th align="center" style="width: 8%;"></th>
                    </tr>
                    @endif

                @endif
            </thead>
            <tbody>
               
                @forelse($list_data as $data )

                    @if($group == 'av')
                        <tr>
                            <td class="pl-1" >{{ get_format_date($data->date_valeur) }}</td>
                            <td class="pl-1">{{ $data->ref_facture }}</td> 
                            <td class="pl-1">{{ $data->intitule }}</td>
                            <td class="pl-1">{{ $data->denomination }}</td>
                            <td align="right">{{ get_format_montant($data->montant) }}</td>
                            <td align="center">{{ $data->devise }}</td>
                            <td align="center"><a class="text-primary" style="cursor:pointer;"
                            wire:click="$dispatch('showDetail',[{{ $data->id }}])" ><i class="dw dw-eye"></i> détail </a
                            ></td>
                        </tr>
                    @endif


                    @if($group == 'bc')
                        <tr>
                            <td class="pl-1" >{{ get_format_date($data->date_valeur) }}</td>
                            <td class="pl-1">{{ $data->intitule }}</td>
                            <td class="pl-1">{{ $data->denomination }}</td>
                            <td align="right">{{ get_format_montant($data->montant) }}</td>
                            <td align="center">{{ $data->devise }}</td>
                            <td align="center"><a class="text-primary" style="cursor:pointer;"
                            wire:click="$dispatch('showDetail',[{{ $data->id }}])" ><i class="dw dw-eye"></i> détail</a
                            ></td>
                        </tr>
                    @endif

                    @if($group == 'od_av')
                        <tr>
                            <td class="pl-1" >{{ get_format_date($data->date_valeur) }}</td>
                            <td class="pl-1">{{ $data->intitule }}</td>
                            <td class="pl-1">{{ $data->denomination }}</td>
                            <td class="pl-1">{{ $data->justification }}</td>
                            <td align="right">{{ get_format_montant($data->montant) }}</td>
                            <td align="center">{{ $data->devise }}</td>
                            <td align="center">
                                <iframe src="{{ asset($data->file_justif) }}" width="100%" height="100%">

                                    Télécharger le PDF
                                    
                                    </iframe>
                                </td>

                            <td align="center"><a class="text-primary" style="cursor:pointer;"
                            wire:click="$dispatch('showDetail',[{{ $data->id }}])" ><i class="dw dw-eye"></i> détail</a
                            ></td>
                        </tr>
                    @endif

                    @if($group == 'od')
                        <tr>
                            <td class="pl-1">{{ get_format_date($data->date_valeur) }}</td>
                            <td class="pl-1">{{ $data->intitule }}</td>
                            <td class="pl-1">{{ $data->justification }}</td>
                            <td align="right">{{ get_format_montant($data->montant) }}</td>
                            <td align="center">{{ $data->devise }}</td>
                            <td align="center"><a class="text-primary" style="cursor:pointer;"
                            wire:click="$dispatch('showDetail',[{{ $data->id }}])" ><i class="dw dw-eye"></i> détail</a
                            ></td>
                        </tr>
                    @endif
    
                @empty
                    <tr>
                        <td colspan="7" align="center">Aucune donnée trouvée</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
        {{ $list_data->links() }}
    </div>
</div>
