<div>

    <div  wire:ignore.self
									class="modal fade bs-example-modal-lg"
									id="DetailTransactionModal"
									tabindex="-1"
									role="dialog"
									aria-labelledby="TransactionModal"
									aria-hidden="true"
								>
									<div class="modal-dialog modal-lg modal-dialog-centered">
										<div class="modal-content">
											<div class="modal-header">
												<h4 class="modal-title" id="TransactionModal">
													Détails
												</h4>
												<button
													type="button"
													class="close"
													data-dismiss="modal"
													aria-hidden="true"
												>
													×
												</button>
											</div>
											<div class="modal-body">
												<div class="table-responsive">
                                                    <table class="table table-sm table-striped">
                                                        <thead>
                                                            <tr>
                                                                <th colspan="5">{{ $this->title_detail }}</th>
                                                            </tr>
                                                            @if($list_data_detail)
                                                                <tr>
                                                                    <th scope="col">Compte</th>
                                                                    <th scope="col">Intitulé</th>
                                                                    <th scope="col">Débit</th>
                                                                    <th scope="col"> Crédit</th>
                                                                    <th scope="col">Devise</th>
                                                                </tr>
                                                            @endif
                                                        </thead>
                                                        <tbody>
                                                           
                                                            @forelse($list_data_detail as $data )
                                                                <tr>
                                                                    <td >{{ $data->fk_num_compte }}</td>
                                                                    <td>{{ $data->nom_compte }}</td>
                                                                    <td>{{ get_format_montant($data->debit) }}</td>
                                                                    <td>{{ get_format_montant($data->credit) }}</td> 
                                                                    <td>{{ $data->devise }}</td>
                                                                </tr>
                                                            @empty
                                                                <tr>
                                                                    <td colspan="5" align="center">Aucune donnée trouvée</td>
                                                                </tr>
                                                            @endforelse
                                                            
                                                            
                                                        </tbody>
                                                    </table>
                                                </div>
											</div>
							<div class="modal-footer">
								<button
									type="button"
									class="btn btn-secondary"
									data-dismiss="modal"
								>
								Close
						        </button>
					        </div>
				</div>
			</div>
	</div>




    <div class="table-responsive">
        <table id="table" class="table-striped mb-2" border="1" style="width:100%; font-size:0.8rem;">
            <thead>
                
                @if($list_data)

                    @if($group == 'av')
                    <tr>
                        <th class="pl-1" style="width: 11%;">Date</th>
                        <th class="pl-1" style="width: 10%;">Référence</th>
                        <th class="pl-1" style="width: 10%;">N° Facture</th>
                        <th class="pl-1" >Libellé</th>
                        <th class="pl-1" >Désignation</th>
                        <th class="pl-1" >Montant</th>
                        <th  style="width: 6%;">Devise</th>
                       <!--  <th ></th> -->
                    </tr>
                    @endif

                    @if($group == 'bc')
                    <tr>
                        <th scope="col">Date</th>
                        <th scope="col">Libellé</th>
                        <th scope="col">Montant</th>
                        <th scope="col">Devise</th>
                        <th scope="col">Désignation</th>
                        <th scope="col"></th>
                    </tr>
                    @endif

                    @if($group == 'od')
                    <tr>
                        <th scope="col">Date</th>
                        <th scope="col">Libellé</th>
                        <th scope="col">Montant</th>
                        <th scope="col">Devise</th>
                        <th scope="col">Justification</th>
                        <th scope="col"></th>
                    </tr>
                    @endif

                @endif
            </thead>
            <tbody>
               
                @forelse($list_data as $data )

                    @if($group == 'av')
                        <tr>
                            <td class="pl-1" >{{ get_format_date($data->date_valeur) }}</td>
                            <td class="pl-1">{{ $data->num_facture }}</td> 
                            <td class="pl-1">{{ $data->num_facture }}</td> 
                            <td class="pl-1">{{ $data->intitule }}</td>
                            <td class="pl-1">{{ $data->denomination }}</td>
                            <td align="right">{{ get_format_montant($data->montant) }}</td>
                            <td align="center">{{ $data->devise }}</td>
                           <!--  <td><a class="text-primary" style="cursor:pointer;"
                            wire:click="showDetail({{ $data->id }})" ><i class="dw dw-eye"></i> show</a
                            ></td> -->
                        </tr>
                    @endif


                    @if($group == 'bc')
                        <tr>
                            <td class="pl-1" >{{ get_format_date($data->date_valeur) }}</td>
                            <td class="pl-1">{{ $data->intitule }}</td>
                            <td class="pl-1">{{ get_format_montant($data->montant) }}</td>
                            <td>{{ $data->devise }}</td>
                            <td>{{ $data->denomination }}</td>
                            <td><a class="text-primary" style="cursor:pointer;"
                            wire:click="showDetail({{ $data->id }})" ><i class="dw dw-eye"></i> show</a
                            ></td>
                        </tr>
                    @endif

                    @if($group == 'od')
                        <tr>
                            <td >{{ get_format_date($data->date_valeur) }}</td>
                            <td>{{ $data->intitule }}</td>
                            <td>{{ get_format_montant($data->montant) }}</td>
                            <td>{{ $data->devise }}</td>
                            <td>{{ $data->justification }}</td>
                            <td><a class="text-primary" style="cursor:pointer;"
                            wire:click="showDetail({{ $data->id }})" ><i class="dw dw-eye"></i> show</a
                            ></td>
                        </tr>
                    @endif
    
                @empty
                    <tr>
                        <td colspan="7" align="center">Aucune donnée trouvée</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
        {{ $list_data->links() }}
    </div>
    
</div>
