<div>

        <!--- Modal --->

        <div wire:ignore.self
        class="modal fade"
        id="CompteTiersClModal"
        tabindex="-1"
        role="dialog"
        aria-labelledby="myLargeCompteClientModal"
        aria-hidden="true"
    >
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myLargeCompteClientModal">
                        {{ $title_modal_cl }}
                    </h4>
                    <button
                        type="button"
                        class="close"
                        wire:click="CloseModalNewCompteCl"
                    >
                        ×
                    </button>
                </div>
                <form method="POST">
                <div class="modal-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="">Tiers - Client <span style="color:red;">*</span></label>
                                        <select  class="form-control" wire:model="tiers_id_cl"  >
                                            <option value=""> -- Select -- </option>
                                            @foreach(get_select_tiers('client') AS $data )
                                               
                                                <option value="{{ $data->id }}">{{ $data->denomination }}</option>
                                            @endforeach
                                        </select>
                                        @error('tiers_id')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="">Numéro compte <span style="color:red;">*</span></label>
                                        <input type="text"  class="form-control" wire:model="num_compte_cl" placeholder="41xxxxxx" maxlength="8" @if(!$isNew_cl)  readonly @endif>
                                        @error('num_compte_cl')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="">Intitulé compte <span style="color:red;">*</span></label>
                                        <input type="text" name="nom_compte" id="" class="form-control" wire:model="nom_compte_cl" placeholder="intitulé du compte" maxlength="100">
                                        @error('nom_compte_cl')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                </div>
                <div class="modal-footer">
                    <button
                        type="button"
                        class="btn btn-secondary"
                        wire:click="CloseModalNewCompteCl"
                    >
                        Close
                    </button>
                    <button type="button" class="btn @if($isNew_cl) btn-primary @else btn-success @endif" wire:click="saveCompteTiersCl" wire:loading.attr="disabled" style="width:28%;">
                        <div class="spinner-border spinner-border-sm"  role="status" wire:loading wire:target="saveCompteTiersCl">
                            <span class="visually-hidden"></span>
                        </div>
        
                        <div wire:loading.remove wire:target="saveCompteTiersCl">
                            @if($isNew_cl)  Enregistrer 
                            @else  Mettre à jour
                            @endif
                        </div>
                    </button>
                </div>
            </form>
            </div>
        </div>
    </div>
<!-- end modal ---->

<!--- Modal --->

        <div wire:ignore.self
        class="modal fade"
        id="CompteTiersFnModal"
        tabindex="-1"
        role="dialog"
        aria-labelledby="myLargeCompteFournModal"
        aria-hidden="true"
    >
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myLargeCompteFournModal">
                        {{ $title_modal_fn }}
                    </h4>
                    <button
                        type="button"
                        class="close"
                        wire:click="CloseModalNewCompteFn"
                    >
                        ×
                    </button>
                </div>
                <form method="POST">
                <div class="modal-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="">Tiers - Fournisseur <span style="color:red;">*</span></label>
                                        <select  class="form-control" wire:model="tiers_id_fn"  >
                                            <option value=""> -- Select -- </option>
                                            @foreach(get_select_tiers('fourn') AS $data )
                                              
                                                <option value="{{ $data->id }}">{{ $data->denomination }}</option>
                                            @endforeach
                                        </select>
                                        @error('tiers_id_fn')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="">Numéro compte <span style="color:red;">*</span></label>
                                        <input type="text"  class="form-control" wire:model="num_compte_fn" placeholder="40xxxxxx OU 48xxxxxx" maxlength="8" @if(!$isNew_fn)  readonly @endif>
                                        @error('num_compte_fn')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="">Intitulé compte <span style="color:red;">*</span></label>
                                        <input type="text" name="nom_compte" id="" class="form-control" wire:model="nom_compte_fn" placeholder="intitulé du compte" maxlength="100">
                                        @error('nom_compte_fn')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                </div>
                <div class="modal-footer">
                    <button
                        type="button"
                        class="btn btn-secondary"
                        wire:click="CloseModalNewCompteFn"
                    >
                        Close
                    </button>
                    <button type="button" class="btn @if($isNew_fn) btn-primary @else btn-success @endif" wire:click="saveCompteTiersFn" wire:loading.attr="disabled" style="width:28%;">
                        <div class="spinner-border spinner-border-sm"  role="status" wire:loading wire:target="saveCompteTiersFn">
                            <span class="visually-hidden"></span>
                        </div>
        
                        <div wire:loading.remove wire:target="saveCompteTiersFn">
                            @if($isNew_fn)  Enregistrer 
                            @else  Mettre à jour
                            @endif
                        </div>
                    </button>
                </div>
            </form>
            </div>
        </div>
    </div>
<!-- end modal ---->




    <div class="profile-tab height-100-p">
        <div class="tab height-100-p">
            <ul class="nav nav-tabs customtab" role="tablist">
                <li class="nav-item">
                    <a wire:click.prevent="selectTab('client')" class="nav-link {{ $tab == 'client' ? 'active' : '' }}" data-toggle="tab" href="#timeline" role="tab">Client</a>
                </li>
                <li class="nav-item">
                    <a wire:click.prevent="selectTab('fourn')" class="nav-link {{ $tab == 'fourn' ? 'active' : '' }}" data-toggle="tab" href="#tasks" role="tab">Fournisseur</a>
                </li>
            </ul>
            <div class="tab-content">
                <!-- Timeline Tab start -->
                <div class="tab-pane fade {{ $tab == 'client' ? 'show active' : '' }}" id="timeline" role="tabpanel">
                    <div class="pd-20">

                       
                        <div class="clearfix mb-20">
                            <div class="pull-right">
                                <button
                                    type="button"
                                    class="btn btn-primary btn-sm scroll-click"
                                    rel="content-y"
                                    wire:click="OpenModalNewCompteCl"
                                    
                                    ><i class="fa fa-plus"></i> Créer un Compte de Tiers
                                </button>
                            </div>
                        </div>
                           
                        

                        @php
                            $n = 1;
                        @endphp

                        <div class="row"> 

                            <div class="col-md-1">
                                <div class="input-group custom ">
                                    <select wire:model.live="per_page_cl"  class="form-control form-control-sm" >
                                        <option value="10">10</option>
                                        <option value="25">25</option>
                                        <option value="50">50</option>
                                        <option value="75">75</option>
                                        <option value="100">100</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6 offset-md-5">
                                <div class="input-group custom ">
                                        <input
                                            type="text"
                                            class="form-control form-control-sm"
                                            placeholder="recherche"
                                            id="_filter"
                                            wire:model.live="search"
                                        />
                                        <div class="input-group-append custom">
                                            <span class="input-group-text"
                                                ><i class="icon-copy dw dw-search"></i
                                            ></span>
                                        </div>
                                </div>
                            </div>
                        </div>
                        <div class="table-responsive">
							<table id="table" class="table-striped mb-2" border="1" style="width:100%; font-size:15px;">
								<thead>
									<tr>
										<td align="center" style="width: 4%;"><b>#</b></td>
										<td class="pl-1" style="width: 10%;"><b>Compte</b></td>
										<td class="pl-1"><b>Intitulé</b></td>
										<td style="width: 30%;"><b>Denomination</b></td>
										<td align="center" style="width: 8%;"></td>
									</tr>
								</thead>
								<tbody>
                                   
                                    @forelse($list_tiers_client as $list )
                                        <tr>
                                            <td align="center">{{ $n }}</td>
                                            <td  class="pl-1">{{ $list->compte }}</td>
                                            <td  class="pl-1">{{ $list->intitule }}</td>
                                            <td  class="pl-1">{{ $list->denomination }}</td>
                                            <td align="center"><a class="text-primary" href="#"
                                             wire:click="editCompteCompta({{ $list->id }})" ><i class="dw dw-edit2"></i> edit</a
                                             ></td>
                                        </tr>

                                        @php
                                            $n++ ;
                                        @endphp
                                    @empty
                                        <tr>
                                            <td colspan="5" align="center">Aucune donnée trouvée</td>
                                        </tr>
                                    @endforelse
									
                                    
								</tbody>
							</table>
                            {{ $list_tiers_client->links() }}
						</div>
                    </div>
                </div>
                <!-- Timeline Tab End -->
                <!-- Tasks Tab start -->
                <div class="tab-pane fade {{ $tab == 'fourn' ? 'show active' : '' }}" id="tasks" role="tabpanel">
                   <div class="pd-20 profile-task-wrap">
                    <div class="clearfix mb-20">
                        <div class="pull-right">
                            <button
                                type="button"
                                class="btn btn-primary btn-sm scroll-click"
                                rel="content-y"
                                wire:click="OpenModalNewCompteFn"
                                
                                ><i class="fa fa-plus"></i> Créer un Compte de Tiers
                            </button>
                        </div>
                    </div>
                       
                    

                    @php
                        $n = 1;
                    @endphp

                    <div class="row"> 

                        <div class="col-md-1">
                            <div class="input-group custom ">
                                <select wire:model.live="per_page_fn"  class="form-control form-control-sm" >
                                    <option value="10">10</option>
                                    <option value="25">25</option>
                                    <option value="50">50</option>
                                    <option value="75">75</option>
                                    <option value="100">100</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6 offset-md-5">
                            <div class="input-group custom ">
                                    <input
                                        type="text"
                                        class="form-control form-control-sm"
                                        placeholder="recherche"
                                        id="_filter"
                                        wire:model.live="search"
                                    />
                                    <div class="input-group-append custom">
                                        <span class="input-group-text"
                                            ><i class="icon-copy dw dw-search"></i
                                        ></span>
                                    </div>
                            </div>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table id="table" class="table-striped mb-2" border="1" style="width:100%; font-size:15px;">
                            <thead>
                                <tr>
                                    <td align="center" style="width: 4%;"><b>#</b></td>
                                    <td class="pl-1" style="width: 10%;"><b>Compte</b></td>
                                    <td class="pl-1"><b>Intitulé</b></td>
                                    <td style="width: 30%;"><b>Denomination</b></td>
                                    <td align="center" style="width: 8%;"></td>
                                </tr>
                            </thead>
                            <tbody>
                               
                                @forelse($list_tiers_fourn as $list )
                                    <tr>
                                        <td align="center">{{ $n }}</td>
                                        <td  class="pl-1">{{ $list->compte }}</td>
                                        <td  class="pl-1">{{ $list->intitule }}</td>
                                        <td  class="pl-1">{{ $list->denomination }}</td>
                                        <td align="center"><a class="text-primary" href="#"
                                         wire:click="editCompteCompta({{ $list->id }})" ><i class="dw dw-edit2"></i> edit</a
                                         ></td>
                                    </tr>

                                    @php
                                        $n++ ;
                                    @endphp
                                @empty
                                    <tr>
                                        <td colspan="5" align="center">Aucune donnée trouvée</td>
                                    </tr>
                                @endforelse
                                
                                
                            </tbody>
                        </table>
                        {{ $list_tiers_fourn->links() }}
                    </div>
                   
                   </div>
                </div>
                <!-- Tasks Tab End -->
              
            </div>
        </div>

    </div>
</div>




@push('scripts')

<script>
    	window.addEventListener('hideModalCl', event => {
					$('#CompteTiersClModal').modal('hide');
                  //  $('#modal-update-admin-lg').modal('hide');
				})

        window.addEventListener('showModalCl', event => {
					$('#CompteTiersClModal').modal('show');
				})

        window.addEventListener('hideModalFn', event => {
            $('#CompteTiersFnModal').modal('hide');
            //  $('#modal-update-admin-lg').modal('hide');
        })

        window.addEventListener('showModalFn', event => {
					$('#CompteTiersFnModal').modal('show');
				})
        
</script>
    
@endpush