<div>
    
    <div wire:ignore.self
                class="modal fade"
                id="confirmation_modal_taux_change"
                tabindex="-1"
                role="dialog"
                aria-hidden="true"
                data-backdrop="static"
            >
                <div
                    class="modal-dialog modal-dialog-centered"
                    role="document"
                >
                    <div class="modal-content">
                        <div class="modal-body text-center font-18">
                            <h4 class="padding-top-30 mb-30 weight-500">
                                Voulez-vous faire ce changement?
                            </h4>
                            <div
                                class="padding-bottom-30 row"
                                style="max-width: 170px; margin: 0 auto"
                            >
                                <div class="col-6">
                                    <button
                                        type="button"
                                        class="btn btn-secondary border-radius-100 "
                                        data-dismiss="modal"
                                    >
                                    <i class="fa fa-times"></i> Non
                                        </button>
                                                    
                        </div>
                        <div class="col-6">
                            <button
                                type="button"
                                class="btn btn-primary border-radius-100 "
                                wire:click="storeTauxChange"
                            >
                                <i class="fa fa-check"></i> Oui
                            </button>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div wire:ignore.self
                class="modal fade"
                id="confirmation_modal_cloture_periode"
                tabindex="-1"
                role="dialog"
                aria-hidden="true"
                data-backdrop="static"
            >
                <div
                    class="modal-dialog modal-dialog-centered"
                    role="document"
                >
                    <div class="modal-content">
                        <div class="modal-body text-center font-18">
                            <h4 class="padding-top-30 mb-30 weight-500">
                                Voulez-vous faire cette clôture d'une période ?
                            </h4>
                            <div
                                class="padding-bottom-30 row"
                                style="max-width: 170px; margin: 0 auto"
                            >
                                <div class="col-6">
                                    <button
                                        type="button"
                                        class="btn btn-secondary border-radius-100 "
                                        data-dismiss="modal"
                                    >
                                    <i class="fa fa-times"></i> Non
                                        </button>
                                                    
                        </div>
                        <div class="col-6">
                            <button
                                type="button"
                                class="btn btn-primary border-radius-100 "
                                wire:click="StoreCloturePeriode"
                            >
                                <i class="fa fa-check"></i> Oui
                            </button>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div wire:ignore.self
    class="modal fade"
    id="confirmation_modal_cloture_exercice"
    tabindex="-1"
    role="dialog"
    aria-hidden="true"
    data-backdrop="static"
>
    <div
        class="modal-dialog modal-dialog-centered"
        role="document"
    >
        <div class="modal-content">
            <div class="modal-body text-center font-18">
                <h4 class="padding-top-30 mb-30 weight-500">
                    Voulez-vous clôturer {{ getExercice() }}  ?
                </h4>
                <div
                    class="padding-bottom-30 row"
                    style="max-width: 170px; margin: 0 auto"
                >
                    <div class="col-6">
                        <button
                            type="button"
                            class="btn btn-secondary border-radius-100 "
                            data-dismiss="modal"
                        >
                        <i class="fa fa-times"></i> Non
                            </button>
                                        
            </div>
            <div class="col-6">
                <button
                    type="button"
                    class="btn btn-primary border-radius-100 "
                    wire:click="StoreClotureExercice"
                >
                    <i class="fa fa-check"></i> Oui
                </button>
                
            </div>
        </div>
    </div>
</div>
</div>
</div>

       
    <div class="profile-tab height-100-p">
        <div class="tab height-100-p">
            <ul class="nav nav-tabs customtab" role="tablist">
                <li class="nav-item">
                    <a wire:click.prevent="selectTab('taux_change')" class="nav-link {{ $tab == 'taux_change' ? 'active' : '' }}" data-toggle="tab" href="#timeline" role="tab">Taux de change</a>
                </li>
                <li class="nav-item">
                    <a wire:click.prevent="selectTab('ouverture')" class="nav-link {{ $tab == 'ouverture' ? 'active' : '' }}" data-toggle="tab" href="#ouverture" role="tab">Ouverture Excercice</a>
                </li>
                <li class="nav-item">
                    <a wire:click.prevent="selectTab('cloture')" class="nav-link {{ $tab == 'cloture' ? 'active' : '' }}" data-toggle="tab" href="#tasks" role="tab">Clôture Excercice</a>
                </li>
                <li class="nav-item">
                    <a wire:click.prevent="selectTab('config')" class="nav-link {{ $tab == 'config' ? 'active' : '' }}" data-toggle="tab" href="#config" role="tab">Configuration initiale</a>
                </li>
            </ul>
            <div class="tab-content">
                <!-- Timeline Tab start -->
                <div class="tab-pane fade {{ $tab == 'taux_change' ? 'show active' : '' }}" id="timeline" role="tabpanel">
                    <div class="pd-20">
                        <div class="row">
                            <div class="col-6">
                                <form wire:submit.prevent="saveTauxChange()" action="">
                                    <div class="row">
                                        <div class="col-md-7">
                                            <div class="form-group">
                                                <label for="">A partir de : </label><small> (date)</small>
                                                <input type="date" wire:model="dateChange" class="form-control form-control-sm"   >
                                                @error('dateChange')
                                                    <small class="form-text text-danger">{{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
        
                                    @forelse ( $inputs as $key=>$value )
                                    <div class="row form-group">
                                        <div class="col-md-2">
                                            <input type="text" wire:model="inputs.{{ $key }}.devise_start"  class="form-control form-control-sm"   readonly>
                                        </div>
                                        <div class="col-md-3">
                                            <input type="text" wire:model="inputs.{{ $key }}.taux"  class="form-control form-control-sm">
                                            @error('inputs.'.$key.'.taux')
                                                <small class="form-text text-danger">{{ $message }}</small>
                                            @enderror
                                        </div>
                                        <div class="col-md-2">
                                            <input type="text" wire:model="inputs.{{ $key }}.devise_end" class="form-control form-control-sm"    readonly>
                                        </div>
                                    </div>
                                   
                                    @empty
                                        
                                    @endforelse
                                    
                                    <div class="mb-2">
                                        <p class="mb-1"><span class="text-danger"><small> Important ! </span>
                                        Aucune modification ne sera autorisée après validation</small></p>
                                    </div>
                                    <button type="submit" class="btn btn-primary btn-sm">Enregistrer</button>
                                   
                                </form>
                            </div>
                            <div class="col-6">
                                <div style="height:200px; overflow:auto;">
                                    <table id="table" class="table-striped mb-2" border="1" style="width:100%; font-size:0.8rem;">
                                        <thead>
                                            <tr>
                                                <th colspan="3" class="pl-1"  style="font-size:0.9rem; background-color:beige; text-align:center;">Historique taux de change</th>
                                            </tr>
                                        
                                                <tr>
                                                    <td class="pl-1" style="width: 20%;">De</td>
                                                    <td class="pl-1" style="width: 20%;">Au</td>
                                                    <td class="pl-1" >Taux</td>
                                                   
                                                </tr>
                                            
                                        </thead>
                                        <tbody>
                                           
                                            @forelse(get_historique_tauxChange() as $data )
                                                <tr>
                                                    <td class="pl-1">{{ get_format_date($data->valid_from) }}</td>
                                                    <td class="pl-1">{{ get_format_date($data->valid_to) }}</td>
                                                    <td class="pl-1">
                                                        1 {{ $data->devise_start }} = 
                                                        {{ get_format_montant($data->taux) }}
                                                         {{ $data->devise_end }}
                                                    </td>
                                                    
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="3" align="center">Aucune donnée trouvée</td>
                                                </tr>
                                            @endforelse
                                            
                                            
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                       
                    </div>
                </div>
                <!-- Timeline Tab End -->
                <!-- Tasks Tab start -->
                <div class="tab-pane fade {{ $tab == 'ouverture' ? 'show active' : '' }}" id="ouverture" role="tabpanel">
                   <div class="pd-20 profile-task-wrap">
                    <div class="row">
                        
                        <div class="col-md-6">
                            <form wire:submit.prevent="OpenExercice()">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label for="">Date début </label>
                                        <input type="date"  class="form-control form-control-sm"  wire:model="date_start"   >
                                        @error('date_start')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                   
                                </div>
                                <div class="col-md-6">
                                        <label for="">Date fin </label>
                                        <input type="date"  class="form-control form-control-sm"  wire:model="date_end" >
                                        @error('date_end')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    
                                </div>
                                   
                                </div>
                                <div class="mt-2 mb-2">
                                    <p class="mb-1"><span class="text-danger"><small> Important ! </span>
                                    Aucune modification ne sera autorisée après validation</small></p>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <button type="submit" class="btn btn-primary btn-sm" style="width: 45%;">Ouvrir</button>
                                    </div>
                                   
                                </div>
                                
                                </form>
                        </div>
                        <div class="col-6">
                                <div style="height:200px; overflow:auto;">
                                    <table id="table" class="table-striped mb-2" border="1" style="width:100%; font-size:0.8rem;">
                                        <thead>
                                            <tr>
                                                <th colspan="3" class="pl-1"  style="font-size:0.9rem; background-color:beige; text-align:center;">Historique des Exercices</th>
                                            </tr>
                                        
                                                <tr>
                                                    <td class="pl-1" >Exercice</td>
                                                    <td class="pl-1" style="width: 40%;">Date création</td>
                                                    <td class="pl-1" style="width: 40%;">Date fermeture</td>
                                                    
                                                   
                                                </tr>
                                            
                                        </thead>
                                        <tbody>
                                           
                                            @forelse(get_historique_exercice() as $data )
                                                <tr>
                                                    <td class="pl-1">
                                                         {{ $data->exercice }} 
                                                    </td>
                                                    <td class="pl-1">{{ get_format_date($data->date_crea) }}</td>
                                                    <td class="pl-1">{{ get_format_date($data->date_closed) }}</td>
                                                    
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="3" align="center">Aucune donnée trouvée</td>
                                                </tr>
                                            @endforelse
                                            
                                            
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                    </div>
                 
                   </div>
                </div>
                <!-- Tasks Tab End -->
                 <!-- Tasks Tab start -->
                 <div class="tab-pane fade {{ $tab == 'cloture' ? 'show active' : '' }}" id="tasks" role="tabpanel">
                    <div class="pd-20 profile-task-wrap">
                     <div class="row">
                         <div class="col-md-6">
                            <div style="height:200px; overflow:auto;">
                                <table id="table" class="table-striped mb-2" border="1" style="width:100%; font-size:0.8rem;">
                                    <thead>
                                        <tr>
                                            <th colspan="3" class="pl-1"  style="font-size:0.9rem; background-color:beige; text-align:center;">
                                                Historique des Clôtures périodiques
                                            </th>
                                        </tr>
                                    
                                            <tr>
                                                <td class="pl-1" >Exercice</td>
                                                <td class="pl-1" style="width: 70%;">Jusqu'à</td>
                                            </tr>
                                        
                                    </thead>
                                    <tbody>
                                       
                                        @forelse(get_historique_cloture_periode() as $data )
                                            <tr>
                                                <td class="pl-1">
                                                     {{ $data->exercice }} 
                                                </td>
                                                <td class="pl-1">{{ get_format_date($data->date_valeur) }}</td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="3" align="center">Aucune donnée trouvée</td>
                                            </tr>
                                        @endforelse
                                        
                                    </tbody>
                                </table>
                            </div>
                         </div>
                         <div class="col-md-6">
                             <form >
                                 <div class="row">
                                     <div class="col-md-10">
                                         <div class="form-group">
                                             <label for="">Cloture à la date de</label>
                                             <input type="date"  class="form-control form-control-sm" wire:model="dateCloture" >
                                             @error('dateCloture')
                                                  <small class="form-text text-danger">{{ $message }}</small>
                                             @enderror
                                         </div>
                                     </div>
                                    
                                 </div>
                                 <div class="mb-2">
                                    <p class="mb-1"><span class="text-danger"><small> Important ! </span>
                                    Aucune modification ne sera autorisée après validation</small></p>
                                </div>
                                 <div class="row">
                                     <div class="col-md-6">
                                         <button type="button" wire:click="CloturePeriode" class="btn btn-primary btn-sm">Clôture d'une Période</button>
                                     </div>
                                     <div class="col-md-6">
                                         <button type="button" wire:click="ClotureExercice" class="btn btn-danger btn-sm">Clôture de l'Excercice</button>
                                     </div>
                                 </div>
                                 
                                 </form>
                         </div>
                     </div>
                  
                    </div>
                 </div>
                 <!-- Tasks Tab End -->

                   <!-- Config Tab start -->
                <div class="tab-pane fade {{ $tab == 'config' ? 'show active' : '' }}" id="config" role="tabpanel">
                    <div class="pd-20 profile-task-wrap">
                     <div class="row">
                         
                         <div class="col-md-8">
                             <form wire:submit.prevent="ImportConfig">
                                 <div class="row">
                                     <div class="col-md-4">
                                         <label for="">Tache </label>
                                         <select wire:model="todo"  class="form-control form-control-sm" >
                                            <option value="balanceOuverture">Balance d'ouverture</option>
                                            <option value="100">100</option>
                                        </select>
                                         @error('todo')
                                             <small class="form-text text-danger">{{ $message }}</small>
                                         @enderror
                                    
                                 </div>
                                 <div class="col-md-8">
                                         <label for="">fichier </label>
                                         <input type="file" wire:model="file" accept=".xlsx"
                                         class="form-control-file form-control height-auto form-control-sm" />
                                        @error('file')
                                             <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                     
                                 </div>
                                    
                                 </div>
                                 <div class="mt-2 mb-2">
                                     <p class="mb-1"><span class="text-danger"><small> Important ! </span>
                                     Aucune modification ne sera autorisée après validation</small></p>
                                 </div>
                                 <div class="row">
                                     <div class="col-md-6">
                                         
                                         <button type="submit" class="btn btn-primary btn-sm" wire:loading.attr="disabled" style="width:45%;">
                                            <div class="spinner-border spinner-border-sm"  role="status" wire:loading wire:target="ImportConfig">
                                                <span class="visually-hidden"></span>
                                            </div>
                                            
                                            <div wire:loading.remove wire:target="ImportConfig">
                                                Importer
                                            </div>
                                        </button>
                                     </div>
                                    
                                 </div>
                                 
                                 </form>
                         </div>
                         <div class="col-md-4">
 
                         </div>
                     </div>
                  
                    </div>
                 </div>
                 <!-- Config Tab End -->
              
            </div>
         </div>
    </div>
