<?php

namespace Database\Seeders;

use App\Models\FormeSociale;
use Exception;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class GenerateFormeSociale extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {   
        $datas = [
            'Association',
            'Entreprise d\'Etat',
            'Entreprise Unipersonnelle A Résponsabilité Limitée',
            'Etablissement',
            'Groupement d\'interêt Economique',
            'Société Anonyme',
            'Société en Commandite Simple',
            'Société en Nom Collectif',
            'Société A Résponsabilité Limitée',
            'Société par Actions Simplifiée',
            'Société par Actions Simplifiée Unipersonnelle',
            'Société en Commandite par actions',
            'Autre'
        ];
        
        

        try{
            DB::beginTransaction();
            foreach($datas AS $data):
                FormeSociale::create(['name' => $data]);
            endforeach ;
            DB::commit();
            
        }catch(Exception $e){
            DB::rollBack();
        }
    }
}
