<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('t_rens', function (Blueprint $table) {
            $table->id();
            $table->enum("type_rens", ['number', 'file']);
            $table->string("numero_cible")->nullable();
            $table->string("kyc_cible")->nullable();
            $table->string("upload")->nullable();
            $table->string("infraction");
            $table->text("description");
            $table->boolean('is_active')->default(0);
            $table->string("user_crea");
            $table->timestamps();
            $table->string("user_mod")->nullable();
            $table->timestamp("date_mod")->nullable()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('t_rens');
    }
};
