<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('t_links', function (Blueprint $table) {
            $table->id();
            $table->string('token')->unique();
            $table->string('url');
            $table->unsignedBigInteger('demande')->unique();
            $table->timestamp('expires_at');
            $table->timestamps();
            $table->foreign('demande')->references('id')->on('demandes');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('t_links');
    }
};
