<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('intervenants', function (Blueprint $table) {
            $table->id();
            $table->string('noms');
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->unsignedBigInteger('fk_societe');
            $table->unsignedBigInteger('fk_demande');
            $table->string('user_crea');
            $table->timestamp('date_crea')->useCurrent();
            $table->foreign('fk_societe')->references('id')->on('cpt_tbl_society');
            $table->foreign('fk_demande')->references('id')->on('demandes');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('intervenants');
    }
};
