<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cpt_plan_4_sous_compte', function (Blueprint $table) {
            $table->id();
            $table->string('code')->unique();
            $table->string('intitule');
            $table->string('type')->nullable();
            $table->unsignedBigInteger('compte_div_id');
            $table->foreign('compte_div_id')->references('id')->on('cpt_plan_3_compte_divisionnaire');
            $table->unique(['code','intitule','compte_div_id'],'uq_sous_compte');
        
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cpt_plan_4_sous_compte');
    }
};
