<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cpt_plan_3_compte_divisionnaire', function (Blueprint $table) {
            $table->id();
            $table->string('code')->unique();
            $table->string('intitule');
            $table->string('type')->nullable();
            $table->unsignedBigInteger('compte_principal_id');
            $table->foreign('compte_principal_id')->references('id')->on('cpt_plan_2_compte_principal');
            $table->unique(['code','intitule','compte_principal_id'],'uq_compte_div');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cpt_plan_3_compte_divisionnaire');
    }
};
