<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cpt_tbl_formule', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique();
            $table->string('duree');
            $table->enum('mesure', ['DAY','WEEK','MONTH','YEAR']);
            $table->boolean('is_active')->default(1);
            $table->string('user_crea');
            $table->timestamps();
            $table->comment('table des bouquets');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cpt_tbl_formule');
    }
};
