<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cpt_tbl_society', function (Blueprint $table) {
            $table->id();
            $table->string('raison_sociale')->unique();
            $table->integer('fk_id_forme_sociale')->nullable();
            $table->string('activite_principale')->nullable();
            $table->string('telephone')->nullable();
            $table->string('email')->nullable();
            $table->string('sigle')->nullable();
            $table->string('nom_commerciale')->nullable();
            $table->string('adresse')->nullable();
            $table->string('ville')->nullable();
            $table->string('rue')->nullable();
            $table->string('pays')->nullable();
            $table->string('quartier')->nullable();
            $table->string('identification_nat')->nullable();
            $table->string('num_rccm')->nullable();
            $table->string('num_impot')->nullable();
            $table->boolean('is_active')->default(1);
            $table->string('commentaire')->nullable();
            $table->string('logo')->nullable();
            $table->string('user_crea');
            $table->timestamp('date_crea')->useCurrent();
            $table->timestamp('date_mod')->nullable()->useCurrentOnUpdate();
            $table->comment('table des Entreprises');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cpt_tbl_society');
    }
};
