<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class DateEnd implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $q = \Carbon\Carbon::parse($value)->format('dm') ; 
        if($q <> "3112"){
            $fail('date attendue 31 Dec. ');
        }
    }
}
