<?php

namespace App\Rules;

use App\Models\CompteComptable;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Support\Facades\DB;

class CompteExist implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
       $q = CompteComptable::where(['num_compte' => $value,'id_app' => get_id_app(), 'is_active' => 1])->first();  
       if(!$q){
         $fail('Compte inexistant');
       }
    }
}
