<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class demande extends Model
{
    use HasFactory;
    public $timestamps = false;

    protected $fillable = [
        'object',
        'type_demande',
        'description',
        'date_debut',
        'heure_debut',
        'date_fin',
        'heure_fin',
        'numero_cible',
        'kyc_cible',
        'fk_societe',
        'fk_site',
        'user_crea'
    ];

    public function societe(): BelongsTo
    {
        return $this->belongsTo(Society::class);
    }

    public function site(): BelongsTo
    {
        return $this->belongsTo(site::class);
    }
}
