<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Query\JoinClause;
use Illuminate\Support\Facades\DB;

class Transaction extends Model
{
    use HasFactory;
    protected $table = "cpt_tbl_transaction";
    public $timestamps = false ;

    protected $fillable = [
        'type_transaction',
        'fk_facture_id',
        'fk_tiers_id',
        'montant',
        'devise',
        'fk_idworkday',
        'intitule',
        'date_valeur',
        'justification',
        'observation',
        'file_justif',
        'user_crea',
        'id_app'
    ];


    public static function showDetail($id)
    {
        
        return DB::table('cpt_tbl_comptable AS ct')
                    ->join('cpt_tbl_compte_comptable AS cpt', function (JoinClause $join) {
                        $join->on('ct.fk_num_compte', '=', 'cpt.num_compte')
                            ->where('cpt.id_app', '=', get_id_app());
                    })
                    ->where('ct.fk_transaction_id', $id)
                    ->distinct()
                    ->select('ct.fk_num_compte AS compte', 'cpt.nom_compte AS intitule', 'ct.debit', 'ct.credit', 'ct.devise')
                    ->get();
                  

       /* return   DB::table('cpt_tbl_comptable AS ct')
                    ->join('cpt_tbl_compte_tiers AS cpt', function (JoinClause $join) {
                        $join->on('ct.fk_num_compte', '=', 'cpt.compte')
                            ->where('cpt.id_app', '=', get_id_app());
                    })
                    ->where('ct.fk_transaction_id', $id)
                    ->distinct()
                    ->select('ct.fk_num_compte AS compte', 'cpt.intitule', 'ct.debit', 'ct.credit', 'ct.devise')
                    ->union($first)
                    ->get();*/

    }
}
