<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Tiers extends Model
{
    use HasFactory;

    protected $table = "stk_tbl_tiers";
    public $timestamps = false;

    protected $fillable = [
        'denomination',
        'nom_complet',
        'adresse',
        'email',
        'phone',
        'ville',
        'pays',
        'type_tiers',
        'forme_tiers',
        'user_crea',
        'id_app'
    ] ;
    

    public function scopeSearch($query,$value){
        $query->where('denomination','like','%'.trim($value).'%')
            ->orWhere('nom_complet','like','%'.trim($value).'%') 
            ->orWhere('ville','like','%'.trim($value).'%')
            ->orWhere('pays','like','%'.trim($value).'%')
            ->orWhere('forme_tiers','like','%'.trim($value).'%')  ;
    }
}
