<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Society extends Model
{
    use HasFactory;

    protected $table = "cpt_tbl_society";
    public $timestamps = false ;

    protected $fillable = [
        'raison_sociale',
        'fk_id_forme_sociale',
        'activite_principale',
        'telephone',
        'email',
        'sigle',
        'nom_commerciale',
        'adresse',
        'ville',
        'rue',
        'pays',
        'quartier',
        'identification_nat',
        'num_rccm',
        'num_impot',
        'is_active',
        'commentaire',
        'logo',
        'number_digit_compte',
        'user_crea',
        'date_crea',
        'date_mod'
    ];


    public static function numberDigitCompte()
    {
        return Society::where('id' ,get_id_app())
                        ->select('number_digit_compte')
                        ->first();
    }

    public function scopeSearch($query,$value){
        $query->where('raison_sociale','like','%'.trim($value).'%')
            ->orWhere('activite_principale','like','%'.trim($value).'%') 
            ->orWhere('sigle','like','%'.trim($value).'%')
          /*  ->orWhere('adresse','like','%'.trim($value).'%')*/
            ->orWhere('ville','like','%'.trim($value).'%')
          /*  ->orWhere('pays','like','%'.trim($value).'%') */ ;
    }

    public function demandes(): HasMany
    {
        return $this->hasMany(demande::class);
    }

}
