<?php

namespace App\Models\PlanComptable;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;


class SousCompte extends Model
{
    use HasFactory;

    protected $table = "cpt_plan_4_sous_compte";
    public $timestamps = false ; 

    protected $fillable = [
        'code',
        'intitule',
        'type',
        'compte_divisionnaire_id'
    ];

    public function compteDivisionnaire(): BelongsTo
    {
        return $this->belongsTo(CompteDivisionnaire::class);
    }
}
