<?php

namespace App\Models\PlanComptable;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;


class CompteDivisionnaire extends Model
{
    use HasFactory;

    protected $table = "cpt_plan_3_compte_divisionnaire";
    public $timestamps = false ; 

    protected $fillable = [
        'code',
        'intitule',
        'type',
        'compte_principal_id'
    ];


    public function comptePrincipal(): BelongsTo
    {
        return $this->belongsTo(ComptePrincipal::class);
    }

    public function sousComptes(): HasMany
    {
        return $this->hasMany(SousCompte::class);
    }
}
