<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Query\JoinClause;
use Illuminate\Database\Eloquent\Relations\BelongsTo;


class Facture extends Model
{
    use HasFactory;

    protected $table = "stk_tbl_facture";
    public $timestamps = false ;

    protected $fillable = [
        'type_facture',
        'num_facture',
        'ref_facture',
        'date_facture',
        'fk_tiers_id',
        'intitule',
        'montant',
        'devise',
        'fk_idworkday',
        'solde' ,
        'statut_facture',
        'is_active',
        'user_crea',
        'id_app'
    ];

    /**
     ** NumFac changed on reference facture
     */
    public static function getFactureByNumFac($num)
    {
        return Facture::where(['ref_facture' => $num, 'id_app' => get_id_app() ])->first() ;
    }


    public static function getCompteTiersFacture($idFacture)
    {
        $result = null;
        $result_data = null;

        $result_data = DB::select("SELECT c.`fk_num_compte` as compte 
        FROM `cpt_tbl_comptable` c
        INNER JOIN `cpt_tbl_transaction` t ON c.fk_transaction_id = t.id
        WHERE t.fk_facture_id = ? AND (c.fk_num_compte like '40%' OR c.fk_num_compte like '41%')"
        , [$idFacture]);

        if($result_data)
        {
            $result = collect($result_data)->first()->compte;
        }

        return $result ;
    }

    public static function getSoldeFacture($idFacture)
    {
        $result = null;
        $result_data = null;

        $result_data = DB::select("SELECT IFNULL(SUM(c.debit),0) as debit ,  IFNULL(SUM(c.credit),0) as credit
        FROM `cpt_tbl_comptable` c
        INNER JOIN `cpt_tbl_transaction` t ON c.fk_transaction_id = t.id
        WHERE t.fk_facture_id = ? 
        AND (c.fk_num_compte like '40%' OR c.fk_num_compte like '41%' OR  c.fk_num_compte like '48%')"
        , [$idFacture]);

        if($result_data)
        {
            $result = collect($result_data)->first();
        }

        return $result ;
    }

    public  static function  getFactureEnCours($type,$search,$ligne){
        
        /*DB::table('stk_tbl_facture AS fact')
                ->join('stk_tbl_tiers AS tiers', function (JoinClause $join) {
                $join->on('fact.fk_tiers_id', '=', 'tiers.id')
                    ->where('fact.id_app', '=', get_id_app())
                    ->where('tiers.id_app', '=', get_id_app());
                })
                /* ->where('fact.statut_facture','UNPAID')  */
               /* ->where('fact.type_facture', $type)
                ->search($search)
                ->select('fact.id','tiers.denomination','fact.num_facture',
                        'fact.date_facture','fact.intitule','fact.montant',
                        'fact.solde','fact.devise')
                ->paginate($ligne) ;*/

    }

    public function scopeSearch($query,$value){
        $query->where('intitule','like','%'.trim($value).'%')
            ->orWhere('num_facture','like','%'.trim($value).'%') 
            ->orWhere('ref_facture','like','%'.trim($value).'%')
            ->orWhere('montant','like','%'.trim($value).'%')
            ->orWhere('date_facture','like','%'.trim($value).'%')  ;
    }

    /*public function tier(): BelongsTo
    {
        return $this->belongsTo(Tiers::class);
    }*/
}
