<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompteComptable extends Model
{
    use HasFactory;

    protected $table = "cpt_tbl_compte_comptable";
    public $timestamps = false ; 

    protected $fillable = [
        'num_compte',
        'nom_compte',
        'type_compte',
        'fk_cg_code',
        'is_active',
        'user_crea',
        'id_app',
    ];

    public function scopeSearch($query,$value){
        $query->where('nom_compte','like','%'.trim($value).'%')
            ->orWhere('num_compte','like','%'.trim($value).'%') 
            ->orWhere('type_compte','like','%'.trim($value).'%')
            ;
    }
}
