<?php

namespace App\Livewire;

use App\Models\Society;
use Livewire\Component;
use Exception;

class SettingSociety extends Component
{   
    public $tab = null;
    public $tabname = "identification" ;
    protected $queryString = ['tab'] ;
    public $raison_sociale ,$forme_sociale , $activite_principale, $phone , $email, $logo , $sigle, $adresse,
    $ville, $rue, $pays, $id_nat, $rccm, $num_impot ;
   
    
    public function selectTab($tab){
        $this->tab = $tab ;

    }

    public function mount(){
        $this->tab = request()->tab ? request()->tab : $this->tabname ;
        $society = Society::findOrFail(get_id_app());

        $this->raison_sociale = $society->raison_sociale ;
        $this->forme_sociale = $society->fk_id_forme_sociale ;
        $this->activite_principale = $society->activite_principale ;
        $this->phone = $society->telephone ;
        $this->email = $society->email ;
        $this->logo = $society->logo ;
        $this->sigle = $society->sigle ;
        $this->adresse = $society->adresse ;
        $this->ville = $society->ville ;
        $this->pays = $society->pays ;
        $this->id_nat = $society->identification_nat ;
        $this->rccm = $society->num_rccm ;
        $this->num_impot = $society->num_impot ;

    }

    public function saveIdentification(){

        $this->validate([
            'raison_sociale'  => ['required','unique:cpt_tbl_society,raison_sociale,'.get_id_app()],
            'forme_sociale' => ['nullable','int'],
            'activite_principale' => ['nullable','string'],
            'phone' => ['nullable','string'],
            'email' => ['nullable','email'],
            'sigle' => ['nullable','string'],
        ]);

         try
         {
             //$req = $info->save();
             $society = Society::findOrFail(get_id_app());
             $society->raison_sociale = $this->raison_sociale ;
             $society->fk_id_forme_sociale = $this->forme_sociale;
             $society->activite_principale =  $this->activite_principale ;
             $society->telephone = $this->phone ;
             $society->email = $this->email ;
             $society->sigle = $this->sigle  ;
             $society->user_crea = get_pseudo();
             $society->save();

             $this->showToastr('success|Modification success');

         }catch(Exception $e){
            dd($e) ;
             $this->showToastr('failed|Modification echouée');
         }

    }

    public function saveLocalisation(){

        $this->validate([
            'adresse'  => ['nullable','string'],
            'ville' => ['nullable','string'],
            'pays' => ['nullable','string'],
        ]);

         try
         {
             //$req = $info->save();
             $society = Society::findOrFail(get_id_app());
             $society->adresse = $this->adresse ;
             $society->ville = $this->ville;
             $society->pays =  $this->pays ;
             $society->user_crea = get_pseudo();
             $society->save();

             $this->showToastr('success|Modification success');

         }catch(Exception $e){
             $this->showToastr('failed|Modification echouée');
         }

    }


    public function saveImmatriculation(){

        $this->validate([
            'id_nat'  => ['nullable','string'],
            'rccm' => ['nullable','string'],
            'num_impot' => ['nullable','string'],
        ]);

         try
         {
             //$req = $info->save();
             $society = Society::findOrFail(get_id_app());
             $society->identification_nat = $this->id_nat ;
             $society->num_rccm = $this->rccm;
             $society->num_impot =  $this->num_impot ;
             $society->user_crea = get_pseudo();
             $society->save();

             $this->showToastr('success|Modification success');

         }catch(Exception $e){
             $this->showToastr('failed|Modification echouée');
         }

    }



    public function showToastr($message)
    {
        return $this->dispatch('showToast',
           message : $message
        );
    }

    public function render()
    {
        return view('livewire.setting-society');
    }
}
