<?php

namespace App\Livewire;

use App\Models\Facture;
use Livewire\Component;
use Livewire\WithPagination;
use Illuminate\Support\Carbon;
use App\Models\Transaction;
use Illuminate\Support\Facades\DB;

class SaisieJournauxTable extends Component
{   
    use WithPagination; 
    protected $listeners = ['showFactureEnCours' => 'showFactureEnCour' ,
                            'loadSJTable' => 'doSync',
                            'reloadSJTable' => 'doSync'];

    public $type_journal,$not_Found_label, $groupp,$date_start,$date_end, $ligne = 10 , $search = "";
    public $list_data_detail = [], $title_detail , $is_facture = false ;
    public $tabname = "achat" ;


    public function mount(){
        $this->type_journal = request()->tab ? request()->tab :  $this->tabname ;
        $this->date_start = "2020-01-01" ; //Carbon::now()->format('Y-m-d');
        $this->date_end   = Carbon::now()->format('Y-m-d');

    }

    public function doSync($tab)
    {
        $this->type_journal =  $tab ;
        // request()->tab ? request()->tab :  $this->tabname ;
    }

    public function doSearch(){
        //$this->search = $data['search'] ;
        //$this->type_journal = $data['typeJournal'] ; 
        //$this->list_data = get_journal_comptable($journal,$date_start,$date_end);
        $this->resetValidation();
        $this->validate([
            'date_start' => ['required','date','date_format:Y-m-d'] ,
            'date_end' => ['required','date','date_format:Y-m-d','after_or_equal:date_start'],
        ],
        [
        'date_start.required' => "date 1 obligatoire",
        'date_start.date' => "date 1 format inattendu",
        'date_start.date_format' => "date 1 format inattendu",
        'date_end.required' => "date 2 obligatoire",
        'date_end.date' => "date 2 format inattendu",
        'date_end.date_format' => "date 2 format inattendu",
        'date_end.after_or_equal' => "date 2 doit être sup. à la date 1",
        ]);

    }


    public function showDetail(Transaction $transaction)
    {
        $this->title_detail = "Transaction : ".$transaction->intitule ;
        $this->list_data_detail = DB::select('SELECT  DISTINCT ct.`fk_num_compte`,cpt.`nom_compte`,ct.`debit`,ct.`credit`,ct.`devise` 
                                                FROM `cpt_tbl_comptable` ct 
                                            INNER JOIN `cpt_tbl_compte_comptable` cpt ON ct.fk_num_compte = cpt.num_compte 
                                                                                    AND cpt.`id_app` = :id_app 
                                            WHERE ct.fk_transaction_id =  :id',[':id' => $transaction->id , ':id_app' => get_id_app()]) ;
        $this->is_facture = false ;
        $this->dispatch('showDetailTransactionModal');  
    }

    public function showFactureEnCour()
    {   
        
        $this->title_detail = "Les factures de fournisseurs en cours ";
       // $this->list_data_detail = Facture::getFactureEnCours($this->type_journal);
        $this->is_facture = true ;
        $this->dispatch('showDetailTransactionModal');  
    }

    private function doQuery(){
 
        return get_journal_comptable($this->type_journal,
                                    $this->date_start,$this->date_end,
                                    $this->ligne,$this->search
                                );
    }


    public function updatingSearch()
    {
        $this->resetPage();
    }
    
    public function render()
    {

      
        return view('livewire.saisie-journaux-table', [
            'list_data' => $this->doQuery() ,
            'group' => $this->get_group() ]);
    }


    public function get_group()
    {
        switch ($this->type_journal){
            case 'achat' :
                return 'av' ;
                break;
            case 'vente':
                return 'av';
                break;
            case 'banque' :
                return  'bc';
                break;
            case 'caisse':
                return  'bc';
                break;
            default :
                return 'od';
            }
    }

}
