<?php

namespace App\Livewire;

use App\Rules\CheckTauxChangeByDate;
use App\Rules\CompteExist;
use App\Rules\NumFactureExist;
use Livewire\Component;
use Livewire\WithFileUploads;
use Livewire\Attributes\Validate;


class SaisieJournaux extends Component
{   
    use WithFileUploads;
 
    //#[Validate('image|max:1024')] // 1MB Max
    //public $photo;


    public $tab = null;
    public $tabname = "achat" ;
    protected $queryString = ['tab'] ;
    public $inputs ,$listComptaDevise , $CurrentDate ;
    private $regEx = "([0-9])";
    protected $listeners = ['refreshSaisieJournaux' => '$refresh'];
   

    //**********Variable Onglet Achat */
    public $idFournisseur_achat, $NumFacture_achat,$compte_achat  , $date_achat , $libelle_achat ,$reference_achat, $debit_achat ,$compte_tiers_achat,$value_tiers = '',
    $credit_achat , $devise_achat , $total_ht_achat, $taxe_achat , $total_ttc_achat, $total_debit = 0, $total_credit =0, $isEgal_achat = false ;
    public $readonly_debit_achat = false , $readonly_credit_achat = false , $focus_debit_achat = false , 
            $focus_credit_achat = false ;
    public $MyArray_achat = [] , $ListCompte_achat ;
   // public $isUpdateItem = false ;
    //******* end Block ************** */

    //**********Variable Onglet Vente */
    public $idFournisseur_vente, $NumFacture_vente,$compte_vente = "", $date_vente , $libelle_vente , $debit_vente ,
    $credit_vente , $devise_vente , $total_ht_vente, $taxe_vente , $total_ttc_vente;
    public $readonly_debit_vente = false , $readonly_credit_vente = false ;
    public $MyArray_vente = [] , $ListCompte_vente;

    //**********Variable Onglet OD */
    public $idFournisseur_od, $NumFacture_od,$compte_od = "", $date_od , $libelle_od , $debit_od ,
    $credit_od , $devise_od , $piece_justif , $file_piece_justif , $total_ttc_od;
    public $MyArray_od = [] , $ListCompte_od;
 
    //******* end Block ************** */

    // General Block *************************/
    public function selectTab($tab){
        $this->tab = $tab ;
        //$data = array('typeJournal' => $tab);
        $this->dispatch('reloadSJTable',$tab);
    }

    public function mount(){
        $this->tab = request()->tab ? request()->tab : $this->tabname ;
       // $this->tab = $this->tabname ;
        $this->devise_achat = get_main_devise();
        $this->devise_vente = get_main_devise();
        $this->devise_od = get_main_devise();

        
        // $this->total_ttc_achat = "Wep5556666666666666";
    }

    public function showToastr($message){
        return $this->dispatch('showToast',
           message : $message
        );
    }

    public function render()
    {   
        return view('livewire.saisie-journaux');
    }
    
    //******  Bloc Onglet Achat  *****/


    
    public function addItem_achat(){

        //  $n = array_search($array[$i], array_column($this->_dbFields, 'field')) ;
       /* $data = Validator::make([
          'compte' => $this->compte ,
          'debit' => $this->debit ,
          'credit' => $this->credit
        ],[
          
        ]);*/
       $validator = $this->validate([
            'compte_achat' => ['required', ], // new CompteExist
            'debit_achat'  => ['nullable','numeric','min:0','max:9999999999999.99'],
            'credit_achat' => ['nullable','numeric','min:0','max:9999999999999.99'],
        ],[ 
            'compte_achat.required' => "Compte obligatoire",
            /*'debit_achat.required' => "obligatoire",*/
            'debit_achat.numeric'  => "montant invalide",
            'debit_achat.min'      => "montant invalide",
            'debit_achat.max'      => "montant trop grand",
           /* 'credit_achat.required' => "obligatoire",*/
            'credit_achat.numeric'  => "montant invalide",
            'credit_achat.min'      => "montant invalide",
            'credit_achat.max'      => "montant trop grand",
        ]);
  
          // dd($data->validate());
         //  dd($valid->errors());
        //   $data_v = $validator->validated() ;
       // dd($this->MyArray_achat);
        //   dd(array_column($this->MyArray_achat, 'compte'));
  
      
          $key = array_search($validator['compte_achat'], array_column($this->MyArray_achat, 'compte')) ;

              if(is_int($key) && $key >= 0){

                  $this->showToastr('failed|ce compte existe déjà');

              }else{
                  
                  if(empty(trim($validator['debit_achat'])) && empty(trim($validator['credit_achat'])) ){
                  
                        $this->showToastr('failed|crédit et débit ne peuvent être vide');
                      
                  }elseif($validator['debit_achat'] > 0 && $validator['credit_achat'] > 0){

                        $this->showToastr('failed|crédit et débit ne peuvent avoir des valeurs');

                  }else{
                      $array = array(
                          'compte' => $validator['compte_achat'],
                           'intitule' => get_intitule_compte($validator['compte_achat']),
                          'debit'     => (empty(trim($validator['debit_achat'])))? 0 : $validator['debit_achat']  ,
                          'credit'    => (empty(trim($validator['credit_achat'])))? 0 : $validator['credit_achat']
                      );
          
                      array_push($this->MyArray_achat , $array);
                      $this->check_if_credit_debit_are_egal_achat();
                      $this->resetItem_achat() ;
                  }
              }
    }

    private function check_if_credit_debit_are_egal_achat(){

        $credit = 0;
        $debit  = 0 ;

      //  if(!empty($this->MyArray_achat)){

            foreach($this->MyArray_achat as $array):
                $credit += $array['credit'];
                $debit  += $array['debit'] ;
            endforeach ;
      //  }
       
        $this->total_ttc_achat = ($credit == $debit) ? $credit : null ;
        $this->isEgal_achat = ($credit == $debit && $debit <> 0) ? true : false ;
        $this->total_debit  = $debit ;
        $this->total_credit = $credit ;
        
    }

    public function annulerItem_achat(){
        $this->resetItem_achat();
    }

    public function resetItem_achat(){
        $this->compte_achat =
        $this->debit_achat  =
        $this->credit_achat =  null;
        $this->reset_readOnly_achat() ;
        //$this->isUpdateItem = false ;
        $this->resetValidation() ;
        $this->dispatch('resetSelect_Compte_achat', data : "");
    }

    public function reset_readOnly_achat()
    {   
        $this->debit_achat  =
        $this->credit_achat =  null;
        $this->readonly_credit_achat =
        $this->readonly_debit_achat =
        $this->focus_credit_achat =
        $this->focus_debit_achat = false ;
    }

    public function removeItem_achat($compte){

        $key = array_search($compte, array_column($this->MyArray_achat, 'compte')) ;
        unset($this->MyArray_achat[$key]); 
        $ar = array();

        foreach($this->MyArray_achat as $data):
            array_push($ar,$data);
        endforeach ;
        
        $this->MyArray_achat = $ar ;
        $this->check_if_credit_debit_are_egal_achat();
    }

    public function updatingCompteAchat($value)
    {   
        $this->reset_readOnly_achat() ;
    }

    public function updatedCompteAchat($value)
    {   
        $this->readOnly_achat($value) ;
    }

   

    public function readOnly_achat($string)
    {
       
        if(mb_substr($string,0,2) == 40 || mb_substr($string,0,2) == 48){
            $this->debit_achat = 0 ;
            $this->readonly_debit_achat = $this->focus_credit_achat = true ;
        }
        if(mb_substr($string,0,1) == 6 ){
            $this->credit_achat = 0 ;
            $this->readonly_credit_achat = $this->focus_debit_achat = true ;
        }
    }

    /* public function upTaxe_achat(){

       $value  = $this->taxe_achat ;

        if(!is_null($this->total_ht_achat) && !is_null($value))
        {
           if(preg_match($this->regEx, $value) && preg_match($this->regEx, $this->total_ht_achat))
           {
             $this->calcul_ttc_achat() ;
           }else{
             $this->total_ttc_achat = null;
           }
            
        }
    }

    public function updatedTotal_ht_achat($value){

        if(!is_null($this->taxe_achat))
        {
           if(preg_match($this->regEx, $value) && preg_match($this->regEx, $this->taxe_achat))
           {
             $this->calcul_ttc_achat() ;
           }else{
             $this->total_ttc_achat = null;
           }
            
        }
    }
    */
    /* private function calcul_ttc_achat(){

       $div = 16 / 100 ;
        $pourcentage = 1 + $div ;
        $tot = $this->horsTaxe *  $pourcentage ;
        $sous = $tot - $this->horsTaxe ;
        

        $this->total = $tot.' '.$sous.' '.$this->taxe ;
        $a = int().$this->taxe ;

        $somm = $this->horsTaxe + $this->taxe ;
        if($sous === intval($this->taxe)){
           $this->total_ttc_achat =  $this->total_ht_achat + intval($this->taxe_achat) ;
        }else{

            $this->dispatchBrowserEvent('showToast',[
                'code' => 'failed',
                'message' => 'la taxe ne correspond pas au 16% de tva sous='.$sous.' taxe='.$this->taxe.''
               ]
            );
            $this->total_ttc_achat = null ;
            return false;
        } 
        
    }*/
    

    public function resetForm_achat(){
        $this->idFournisseur_achat =
        $this->NumFacture_achat  =
        $this->date_achat =
        $this->libelle_achat =  
        $this->compte_achat = 
        $this->total_ttc_achat = null;
        $this->MyArray_achat = [] ;

        $this->debit_achat  = 
        $this->credit_achat = null;
        $this->devise_achat = get_main_devise();
        $this->resetValidation() ;
        //$this->dispatch('resetSelect_Tiers_achat', data : "");
    }

    public function updatedIdFournisseurAchat($value)
    {   
        $this->compte_tiers_achat = '' ;
        $this->value_tiers = '';
        $this->ListCompte_achat = get_compte_tiers($value) ;
       //dd($this->ListCompte_achat[0]->num_compte);
        $this->value_tiers = (count($this->ListCompte_achat) > 0)? $this->ListCompte_achat[0]->num_compte : '' ;
        $this->compte_tiers_achat = $this->value_tiers ;
        // get_compte_sj_achat
        // dd($this->ListCompte_achat);
        // dd($this->ListCompte_achat);
        //$this->dispatch('loadSelectCompteAchat');
    }

    public function updatedCompteTiersAchat($value)
    {
        $this->value_tiers = $value;
    }

    public function addItemby()
    {
        $this->addItem_achat() ;
    }

    public function equilibrerJAchat()
    {   

        if(empty(trim($this->compte_tiers_achat)) || is_null($this->compte_tiers_achat)){

            $this->showToastr('failed|Sélectionnez un compte tiers');
        }else{

            $key = array_search($this->compte_tiers_achat, array_column($this->MyArray_achat, 'compte')) ;
           
            if(is_int($key) && $key >= 0){
                $this->removeItem_achat($this->compte_tiers_achat);
            }

            if($this->total_debit <  $this->total_credit)
            {
                $array = array(
                    'compte' => $this->compte_tiers_achat,
                    'intitule' => get_intitule_compte($this->compte_tiers_achat),
                    'debit'  => $this->total_credit - $this->total_debit ,
                    'credit' => 0
                );

                array_push($this->MyArray_achat , $array);
                $this->check_if_credit_debit_are_egal_achat();

            }elseif($this->total_debit >  $this->total_credit){

                $array = array(
                    'compte' => $this->compte_tiers_achat,
                    'intitule' => get_intitule_compte($this->compte_tiers_achat),
                    'debit'  =>  0  ,
                    'credit' => $this->total_debit - $this->total_credit
                );

                array_push($this->MyArray_achat , $array);
                $this->check_if_credit_debit_are_egal_achat();

            }else{
               
                $this->MyArray_achat = [] ;
            }
        }
    }
 

    public function saveAchat()
    {
        $this->validate([
            'idFournisseur_achat' => ['required',],
            'NumFacture_achat' => ['required','string','max:30'],
            'date_achat' => ['required','date','date_format:Y-m-d','before:tomorrow','after:2000-12-31',new CheckTauxChangeByDate],
            'libelle_achat' => ['required','string','min:3','max:100'],
            'total_ttc_achat' => ['required'],
            'devise_achat' => ['required'],
            'MyArray_achat' => ['required','array'],
        ],[
            'idFournisseur_achat.required' => "obligatoire" ,
            'NumFacture_achat.required' => "obligatoire" ,
            'NumFacture_achat.string' => "obligatoire" ,
            'NumFacture_achat.max' => "max. 100 caractères" ,
            'date_achat.required' => "obligatoire" ,
            'date_achat.date' => "format invalide",
            'date_achat.date_format' => "format invalide" ,
            'date_achat.before'    =>  "date erronée", 
            'date_achat.after'     => "date min. 01-01-2001", 
            'libelle_achat.required' => "libellé obligatoire",
            'libelle_achat.string' => "libellé erroné",
            'libelle_achat.min' => "libellé trop court",
            'libelle_achat.max' => "libellé max:100",
            'total_ttc_achat.required' => "obligatoire" ,
            'devise_achat.required' => "obligatoire" ,
            'MyArray_achat.required' => "les comptes mouvementés attendus" ,
            'MyArray_achat.array' => "les comptes mouvementés attendus" ,
        ]);


        $resp = save_saisie_journaux('achat',$this->idFournisseur_achat,null,$this->NumFacture_achat,$this->date_achat,
                    $this->libelle_achat,$this->total_ttc_achat,$this->devise_achat,null,null,$this->MyArray_achat);
        
        if($resp)
        {   
            $this->resetForm_achat();

            $tab = request()->tab ? request()->tab : $this->tabname ;
            $this->dispatch('reloadSJTable',$tab);

            $this->showToastr('success|Enregistrement effectué avec succès');
        }else{
            $this->showToastr('failed|une erreur est survenue'); 
        }            
    }




     //************************************************************* */
    //******  Bloc Onglet Vente  **********************************/
    //******************************** *****************************/

    
    public function addItem_vente(){

        $validator = $this->validate([
            'compte_vente' => ['required', new CompteExist],
            'debit_vente'  => ['required','numeric','min:0','max:9999999999999.99'],
            'credit_vente' => ['required','numeric','min:0','max:9999999999999.99'],
        ],[ 
            'compte_vente.required' => "Compte obligatoire",
            'debit_vente.required' => "obligatoire",
            'debit_vente.numeric'  => "montant invalide",
            'debit_vente.min'      => "montant invalide",
            'debit_vente.max'      => "montant trop grand",
            'credit_vente.required' => "obligatoire",
            'credit_vente.numeric'  => "montant invalide",
            'credit_vente.min'      => "montant invalide",
            'credit_vente.max'      => "montant trop grand",
        ]);
  

          $key = array_search($validator['compte_vente'], array_column($this->MyArray_vente, 'compte')) ;
  
              if(is_int($key) && $key >= 0){

                  $this->showToastr('failed|ce compte existe déjà');

              }else{
                  
                  if($validator['debit_vente'] == 0 && $validator['credit_vente'] == 0){
                  
                        $this->showToastr('failed|crédit et débit ne peuvent être égal à 0');
                      
                  }elseif($validator['debit_vente'] > 0 && $validator['credit_vente'] > 0){

                        $this->showToastr('failed|crédit et débit ne peuvent avoir des valeurs');

                  }else{
                      $array = array(
                          'compte' => $validator['compte_vente'] ,
                          'debit'  => $validator['debit_vente'] ,
                          'credit' => $validator['credit_vente']
                      );
          
                      array_push($this->MyArray_vente , $array);
                      $this->check_if_credit_debit_are_egal_vente();
                      $this->resetItem_vente() ;
                  }
              }
    }

    private function check_if_credit_debit_are_egal_vente(){

        $credit = 0;
        $debit  = 0 ;
        foreach($this->MyArray_vente as $array):
            $credit += $array['credit'];
            $debit  += $array['debit'] ;
        endforeach ;

        if($credit == $debit)
        {
            $this->total_ttc_vente =  $credit  ;
        }else{
            $this->total_ttc_vente =  null ;
        }
        
    }

    public function reset_readOnly_vente()
    {   
        $this->debit_vente  =
        $this->credit_vente =  null;
        $this->readonly_credit_vente =
        $this->readonly_debit_vente = false ;
       // $this->focus_credit_vente =
       // $this->focus_debit_vente = 
    }

    public function updatingCompteVente($value)
    {
        $this->reset_readOnly_vente() ;
    }

    public function updatedCompteVente($value)
    {
        $this->readOnly_vente($value) ;
    }

    public function readOnly_vente($string)
    {
       
        if(mb_substr($string,0,2) == 41 ){
            $this->credit_vente = 0 ;
            $this->readonly_credit_vente =  true ;
        }
        if(mb_substr($string,0,1) == 7 ){
            $this->debit_vente = 0 ;
            $this->readonly_debit_vente = true ;
        }
    }

    public function updatedIdFournisseurVente($value)
    {   
        $this->compte_vente = null ;
        $this->ListCompte_vente = get_compte_sj_vente($value) ;
        // dd($this->ListCompte_achat);
        // dd($this->ListCompte_achat);
        //$this->dispatch('loadSelectCompteAchat');
    }


    public function annulerItem_vente(){
        $this->resetItem_vente();
    }

    public function resetItem_vente(){
        $this->compte_vente = 
        $this->debit_vente  = 
        $this->credit_vente = null;
        $this->reset_readOnly_vente();
        $this->resetValidation() ;
        $this->dispatch('resetSelect_Compte_vente', data : "");
      
    }

    public function removeItem_vente($compte){

        $key = array_search($compte, array_column($this->MyArray_vente, 'compte')) ;
        unset($this->MyArray_vente[$key]); 
        $ar = array();

        foreach($this->MyArray_vente as $data):
            array_push($ar,$data);
        endforeach ;
        
        $this->MyArray_vente = $ar ;
        $this->check_if_credit_debit_are_egal_vente();
      
    }

    public function resetForm_vente(){
        $this->idFournisseur_vente =
        $this->NumFacture_vente  =
        $this->date_vente =
        $this->libelle_vente =  
        $this->compte_vente = 
        $this->devise_vente =
        $this->total_ttc_vente = null;
        $this->MyArray_vente = [] ;

        $this->debit_vente  = 
        $this->credit_vente = 0;
        $this->resetValidation() ;
        $this->dispatch('resetSelect_Tiers_vente', data : "");
    }

    public function saveVente()
    {
        $this->validate([
            'idFournisseur_vente' => ['required',],
            'NumFacture_vente' => ['required','string','max:30'],
            'date_vente' => ['required','date','date_format:Y-m-d','before:tomorrow','after:2000-12-31',new CheckTauxChangeByDate],
            'libelle_vente' => ['required','string','min:3','max:100'],
            'total_ttc_vente' => ['required'],
            'devise_vente' => ['required'],
            'MyArray_vente' => ['required','array'],
        ],[
            'idFournisseur_vente.required' => "obligatoire" ,
            'NumFacture_vente.required' => "obligatoire" ,
            'NumFacture_vente.string' => "obligatoire" ,
            'NumFacture_vente.max' => "max. 100 caractères" ,
            'date_vente.required' => "obligatoire" ,
            'date_vente.date' => "format invalide",
            'date_vente.date_format' => "format invalide" ,
            'date_vente.before'    =>  "date erronée", 
            'date_vente.after'     => "date min. 01-01-2001", 
            'libelle_vente.required' => "libellé obligatoire",
            'libelle_vente.string' => "libellé erroné",
            'libelle_vente.min' => "libellé trop court",
            'libelle_vente.max' => "libellé max:100",
            'total_ttc_vente.required' => "obligatoire" ,
            'devise_vente.required' => "obligatoire" ,
            'MyArray_vente.required' => "les comptes mouvementés attendus" ,
            'MyArray_vente.array' => "les comptes mouvementés attendus" ,
        ]);




        $resp = save_saisie_journaux('vente',$this->idFournisseur_vente,null,$this->NumFacture_vente,$this->date_vente,
                    $this->libelle_vente,$this->total_ttc_vente,$this->devise_vente,null,null,$this->MyArray_vente);
        
        if($resp)
        {   
            $this->resetForm_vente();
            $tab = request()->tab ? request()->tab : $this->tabname ;
            $this->dispatch('reloadSJTable',$tab);
            $this->showToastr('success|Enregistrement effectué avec succès');
        }else{
            $this->showToastr('failed|une erreur est survenue'); 
        }            
    }


    
     //************************************************************* */
    //******  Bloc Onglet OD  **********************************/
    //******************************** *****************************/

    
    public function addItem_od(){

    
        $validator = $this->validate([
            'compte_od' => ['required', new CompteExist],
            'debit_od'  => ['required','numeric','min:0','max:9999999999999.99'],
            'credit_od' => ['required','numeric','min:0','max:9999999999999.99'],
        ],[ 
            'compte_od.required' => "Compte obligatoire",
            'debit_od.required' => "obligatoire",
            'debit_od.numeric'  => "montant invalide",
            'debit_od.min'      => "montant invalide",
            'debit_od.max'      => "montant trop grand",
            'credit_od.required' => "obligatoire",
            'credit_od.numeric'  => "montant invalide",
            'credit_od.min'      => "montant invalide",
            'credit_od.max'      => "montant trop grand",
        ]);
  
          $key = array_search($validator['compte_od'], array_column($this->MyArray_od, 'compte')) ;
  
              if(is_int($key) && $key >= 0){

                  $this->showToastr('failed|ce compte existe déjà');

              }else{
                  
                  if($validator['debit_od'] == 0 && $validator['credit_od'] == 0){
                  
                        $this->showToastr('failed|crédit et débit ne peuvent être égal à 0');
                      
                  }elseif($validator['debit_od'] > 0 && $validator['credit_od'] > 0){

                        $this->showToastr('failed|crédit et débit ne peuvent avoir des valeurs');

                  }else{
                      $array = array(
                          'compte' => $validator['compte_od'] ,
                          'debit'  => $validator['debit_od'] ,
                          'credit' => $validator['credit_od']
                      );
          
                      array_push($this->MyArray_od , $array);
                      $this->check_if_credit_debit_are_egal_od();
                      $this->resetItem_od() ;
                  }
              }
    }

    private function check_if_credit_debit_are_egal_od(){

        $credit = 0;
        $debit  = 0 ;
        foreach($this->MyArray_od as $array):
            $credit += $array['credit'];
            $debit  += $array['debit'] ;
        endforeach ;

        if($credit == $debit)
        {
            $this->total_ttc_od =  $credit  ;
        }else{
            $this->total_ttc_od  = null ;
        }
        
    }

    public function annulerItem_od(){
        $this->resetItem_od();
    }

    public function resetItem_od(){
        $this->compte_od = null;
        $this->debit_od  = 0;
        $this->credit_od = 0;
        //$this->isUpdateItem = false ;
        $this->resetValidation() ;
        $this->dispatch('resetSelect_Compte_od', data : "");
    }

    public function removeItem_od($compte){

        $key = array_search($compte, array_column($this->MyArray_od, 'compte')) ;
        unset($this->MyArray_od[$key]); 
        $ar = array();

        foreach($this->MyArray_od as $data):
            array_push($ar,$data);
        endforeach ;
        
        $this->MyArray_od = $ar ;
        $this->check_if_credit_debit_are_egal_od();
    }

    
    public function updatedIdFournisseurOd($value)
    {   
        $this->compte_od = null ;
        $this->ListCompte_od = get_compte_sj_od($value) ;
    }

    public function resetForm_od(){
        $this->idFournisseur_od =
        $this->NumFacture_od  =
        $this->date_od =
        $this->libelle_od =  
        $this->compte_od = 
        $this->devise_od =
        $this->piece_justif =
        $this->file_piece_justif =
        $this->total_ttc_od = null;
        $this->MyArray_od = [] ;
        $this->debit_od  = 
        $this->credit_od = 0;
        $this->resetValidation() ;
        $this->dispatch('resetSelect_Tiers_od', data : "");
    }

    public function saveOD()
    {
      
        $this->validate([
            'idFournisseur_od' => ['required',],
            'piece_justif' => ['nullable','string'],
            'date_od' => ['required','date','date_format:Y-m-d','before:tomorrow','after:2000-12-31',new CheckTauxChangeByDate],
            'libelle_od' => ['required','string','min:3','max:100'],
            'total_ttc_od' => ['required'],
            'devise_od' => ['required'],
            'file_piece_justif' => ['nullable','file','mimes:pdf','max:102400'],
            'MyArray_od' => ['required','array'],
        ],[
            'idFournisseur_od.required' => "obligatoire" ,
            'date_od.required' => "obligatoire" ,
            'date_od.date' => "format invalide",
            'date_od.date_format' => "format invalide" ,
            'date_od.before'    =>  "date erronée", 
            'date_od.after'     => "date min. 01-01-2001", 
            'libelle_od.required' => "libellé obligatoire",
            'libelle_od.string' => "libellé erroné",
            'libelle_od.min' => "libellé trop court",
            'libelle_od.max' => "libellé max:100",
            'total_ttc_od.required' => "obligatoire" ,
            'devise_od.required' => "obligatoire" ,
            'MyArray_od.required' => "les comptes mouvementés attendus" ,
            'MyArray_od.array' => "les comptes mouvementés attendus" ,
        ]);


        $file = null ;
        if(!is_null($this->file_piece_justif))
        {
            $file = $this->file_piece_justif->store('p_justif/'.get_id_app(),'public');
        }

        $resp = save_saisie_journaux('od',$this->idFournisseur_od,null,null,$this->date_od,
                    $this->libelle_od,$this->total_ttc_od,$this->devise_od,$this->piece_justif,$file,$this->MyArray_od);
        
        if($resp)
        {   
            $this->resetForm_od();
            $tab = request()->tab ? request()->tab : $this->tabname ;
            $this->dispatch('reloadSJTable',$tab);
            $this->showToastr('success|Enregistrement effectué avec succès');
        }else{
            $this->showToastr('failed|une erreur est survenue'); 
        }            
    }


}
