<?php

namespace App\Livewire;

use App\Models\PlanComptable\Classe;
use App\Models\PlanComptable\CompteDivisionnaire;
use App\Models\PlanComptable\SousCompte;
use App\Models\Society;
use Exception;
use Illuminate\Support\Facades\DB;
use Livewire\Component;

class PlanComptableOhada extends Component
{   
    public $all = true  ;
    protected $listeners = ['getComptePlanOhada'] ;
    public $errors = "";

    public function BtnPerso()
    {
        $this->all = false ;
    }

    public function createAll()
    {
       
        $number = Society::numberDigitCompte() ;
        
        if(is_null($number->number_digit_compte))
        {
            $this->dispatch('showModalModalNumberDigitCompte') ;
        }else{
            $this->getComptePlanOhada() ;
        }
    }

    public function getComptePlanOhada()
    {   

        $number = Society::numberDigitCompte()->number_digit_compte ;
    
        if($number === 3)
        {
           $comptes = CompteDivisionnaire::all(); 
        }elseif($number > 3)
        {   
            $comptes = SousCompte::all(); 
        }else{
            dd('error');
        }

        foreach($comptes AS $compte):
              
                try
                {   
                    $compt = mb_substr($compte->code.'000000000000000', 0, $number) ;
                    $this->saveCompte($compt,$compte->intitule) ;
                }catch(Exception $e)
                {
                    $this->errors .= $compte->code.' ' ;
                }
        endforeach;
    }

    public function saveCompte($numCompte,$nomCompte)
    {   
        $data = array(
            'num_compte'  => $numCompte,
            'type_compte' => 'credit',
            'nom_compte'  => $nomCompte,
            'id_app'      => get_id_app(),
            'user'        => get_pseudo()
        );

        $response = DB::select('call CPT_SAVE_COMPTE_COMPTABLE(:num_compte,:nom_compte,:type_compte,:id_app,:user)'
        , $data);

       /* if(isset($response[0]->Message)){
                if($response[0]->Message == 1){
                    $this->showToastr('success|Création effectuée avec success');
                    $this->resetFormCompte();
                }else{
                    $this->showToastr('failed|'.$response[0]->Message);
                }
        }else{
            $this->showToastr('failed|Echec de création');
        } */
    }


    public function render()
    {
        return view('livewire.plan-comptable-ohada',
        [
            'classes' => Classe::all(),
        ]);
    }
}
