<?php

namespace App\Livewire;

use Exception;
use Livewire\Component;
use App\Models\Tiers AS Tierss ;
use App\Rules\CompteExist;
use App\Rules\MaxCompte;
use Illuminate\Support\Facades\DB;

class ModalTiers extends Component
{

    public $tab = null;
    public $activeBtnSave = false ;
    public $tabname = "tous" , $tab_t = 'identification';
    protected $queryString = ['tab'] ;
    public  $isNewTiers = true  , $id ;
    public $compte_tiers,$compte_general,$intitule_compte, $list_collect, $dicoCompteTiers = []  ;
    protected $listeners = ['editTiers','NewTiers'];


    public $designation_t,$nom_complet_t,$forme_t,$phone_t,$email_t,$adresse_t,$ville_t,$pays_t,$type_t;

    // General Block *************************/

    public function selectTab_t($tab_t){
        $this->tab_t = $tab_t ;
        
        $this->resetValidation() ;
    }

    public function mount(){
        $this->tab = request()->tab ? request()->tab : $this->tabname ;
        $this->type_t = $this->tab ;
    }

    public function updatedType_t(){
        $this->compte_general = null ;
    }


    
    public function resetForm(){

        $this->designation_t =
        $this->nom_complet_t =
        $this->forme_t =
        $this->phone_t =
        $this->email_t =
        $this->adresse_t =
        $this->ville_t = 
        $this->type_t =
        $this->pays_t = null ;
        $this->isNewTiers = true ;
        $this->dicoCompteTiers = [];
        $this->resetItem();
    } 
    
    public function saveTiers(){

       
        if($this->isNewTiers){

            $this->validate([
                'designation_t' => ['required','string','max:50'],
                'nom_complet_t' => ['required','string','max:150'],
                'forme_t'   => ['required','string'],
                'phone_t'   => ['nullable','string','max:15'],
                'email_t'   => ['nullable','string','max:50'],
                'adresse_t' => ['nullable','string','max:120'],
                'ville_t'   => ['nullable','string','max:50'],
                'pays_t'    => ['nullable','string','max:50'],
                'dicoCompteTiers' => ['array','required']
            ],[
                'designation_t.required' => 'obligatoire',
                'designation_t.max' => 'max. 50 caractères',
                'nom_complet_t.required' => 'obligatoire',
                'nom_complet_t.max' => 'max. 150 caractères',
                'forme_t.required' => 'obligatoire',
            ]);

        }else{


            $this->validate([
                'designation_t' => ['required','string','max:50'],
                'nom_complet_t' => ['required','string','max:150'],
                'forme_t'   => ['required','string'],
                'phone_t'   => ['nullable','string','max:15'],
                'email_t'   => ['nullable','string','max:50'],
                'adresse_t' => ['nullable','string','max:120'],
                'ville_t'   => ['nullable','string','max:50'],
                'pays_t'    => ['nullable','string','max:50'],
            ],[
                'designation_t.required' => 'obligatoire',
                'designation_t.max' => 'max. 50 caractères',
                'nom_complet_t.required' => 'obligatoire',
                'nom_complet_t.max' => 'max. 150 caractères',
                'forme_t.required' => 'obligatoire',
            ]);
            
        }
       
        try{

            DB::beginTransaction();
            if($this->isNewTiers){

                $tiers = Tierss::create([
                    'denomination' => $this->designation_t,
                    'nom_complet' => $this->nom_complet_t ,
                    'adresse' => $this->adresse_t ,
                    'email' => $this-> email_t ,
                    'phone' => $this-> phone_t ,
                    'ville' => $this->ville_t ,
                    'pays' => $this->pays_t ,
                    'type_tiers' => $this->type_t ,
                    'forme_tiers' => $this->forme_t ,
                    'user_crea' => get_pseudo(),
                    'id_app' => get_id_app()
                ]);
        
                $msg = "Enregistrement effectué avec succès";
            }else{

                $tiers = Tierss::find($this->id);
                $tiers->fill([
                   /* 'denomination' => $this->designation_t,*/
                    'nom_complet' => $this->nom_complet_t ,
                   /* 'type_tiers' => $this->type_t , */
                    'adresse' => $this->adresse_t ,
                    'email' => $this-> email_t ,
                    'phone' => $this-> phone_t ,
                    'ville' => $this->ville_t ,
                    'pays' => $this-> pays_t ,
                    'forme_tiers' => $this->forme_t ,
                ]);
                $tiers->save();

                $msg = "Modification effectuée avec succès";
            }
            
            /**! Insertion only  Compte de tiers  */
            foreach($this->dicoCompteTiers as $dico ):

                if($dico['is_new'] == 1){
                    $data = array(
                        'num_compte'  => $dico['compte_tiers'],
                        'nom_compte'  => $dico['intitule_compte'],
                        'compte_general'  => $dico['compte_general'],
                        'id_tiers'    => $tiers->id,
                        'id_app'      => get_id_app(),
                        'user'        => get_pseudo()
                    );

                    $response = DB::select('call CPT_SAVE_COMPTE_TIERS(:num_compte,:nom_compte
                                                                        ,:compte_general,:id_tiers
                                                                        ,:id_app,:user)'
                    , $data);
                }
            endforeach;
           // dd($response[0]->Message);
            if(isset($response[0]->Message)){
                if($response[0]->Message == 1){
                   // DB::commit();
                    $this->resetForm();
                    $this->showToastr('success|'.$msg);
                }else{
                    DB::rollBack();
                    $this->showToastr('failed|'.$response[0]->Message);
                }
            }else{
                DB::rollBack();
                $this->showToastr('failed|une erreur est survenue '); 
            }  
            
        }catch(Exception $e){
            DB::rollBack();
            $this->showToastr('failed|une erreur est survenue '); 
        }
    }


    public function saveAndCloseModalTiers()
    {
        $this->saveTiers();
        $this->CloseModalTiers();
    }

    public function NewTiers()
    {   
        $this->tab_t = "identification";
        $this->type_t =  ($this->tab === 'tous')? '': $this->tab ;
        $this->OpenModalTiers();
    }


    public function CloseModalTiers()
    {    
        $this->resetForm();
        $this->dispatch('refreshTiers');
        $this->dispatch('refreshSaisieJournaux');
        $this->dispatch('hideModalTiers');
    }

    public function OpenModalTiers()
    {   
        $this->dispatch('showModalTiers');
    }

    public function editTiers(Tierss $tiers)
    {    
                $this->resetForm();
                $this->fill([
                    'designation_t'   => $tiers->denomination ,
                    'nom_complet_t' => $tiers->nom_complet,
                    'adresse_t'  => $tiers->adresse ,
                    'email_t'  => $tiers->email ,
                    'phone_t'   => $tiers->phone ,
                    'ville_t'  => $tiers->ville,
                    'pays_t' =>  $tiers->pays,
                    'forme_t'  => $tiers->forme_tiers,
                    'type_t'  => $tiers->type_tiers,
                ]);

        $this->id = $tiers->id;

        $list = get_compte_of_tiers($tiers->id);
        $ar = array();

        foreach($list as $data):

            $array = array(
                'compte_tiers' => $data->compte_tiers ,
                'intitule_compte'  => $data->intitule_compte ,
                'compte_general' => $data->compte_general ,
                'is_new'         => 0
            );
            array_push($ar,$array);
        endforeach ;
        
        $this->dicoCompteTiers = $ar ;

        $this->isNewTiers = false ;
        $this->OpenModalTiers();
            
    }
    
    public function addItem(){

       $validator = $this->validate([
            'compte_tiers' => ['required','string',new MaxCompte ],
            'intitule_compte'  => ['required','string','min:3','max:150'],
            'compte_general' => ['required',new CompteExist],
        ],[ 
            'compte_tiers.required' => "Compte tiers obligatoire",
            'compte_tiers.string' => "une chaine de carac. attendue",
            'compte_tiers.max'  => "Compte tiers max: 8 carac.",
            'intitule_compte.required'      => "intitulé obligatoire",
            'intitule_compte.string'      => "intitulé doit être une chaine de carac.",
            'intitule_compte.min' => "intitulé min:3 carac.",
            'intitule_compte.max'  => "intitulé max:150 carac.",
            'compte_general.required'      => "compte général obligatoire ",
            
        ]);
        
            $key = array_search($validator['compte_tiers'], array_column($this->dicoCompteTiers, 'compte_tiers')) ;
            $key_lib = array_search($validator['intitule_compte'], array_column($this->dicoCompteTiers, 'intitule_compte')) ;
               
            if(is_int($key) && $key >= 0){

                  $this->showToastr('failed|ce compte tiers existe déjà');

            }else if(is_int($key_lib) && $key_lib >= 0){

                $this->showToastr('failed|cet intitulé existe déjà');

            }else{
                    $array = array(
                          'compte_tiers' => $validator['compte_tiers'] ,
                          'intitule_compte'  => $validator['intitule_compte'] ,
                          'compte_general' => $validator['compte_general'] ,
                          'is_new'         => 1
                    );
          
                    array_push($this->dicoCompteTiers , $array);
                    $this->resetItem() ;
                    if(!$this->activeBtnSave)
                    {
                        $this->activeBtnSave = true ;
                    }
                    
            }

    }

    public function removeItem($compte_tiers){

        $key = array_search($compte_tiers, array_column($this->dicoCompteTiers, 'compte_tiers')) ;
        unset($this->dicoCompteTiers[$key]); 
        $ar = array();

        foreach($this->dicoCompteTiers as $data):
            array_push($ar,$data);
        endforeach ;
        $this->dicoCompteTiers = $ar ;

        if(count($this->dicoCompteTiers) < 1){
            $this->activeBtnSave = false ;
        }

        
    }

    public function resetItem(){
        $this->compte_tiers =
        $this->intitule_compte  =
        $this->compte_general =  null;
       
        $this->resetValidation() ;
       
    }

    public function showToastr($message){
        return $this->dispatch('showToast',
           message : $message
        );
    }

    public function render()
    {
        return view('livewire.modal-tiers');
    }
}
