<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Facture;
use Livewire\WithPagination;

class ModalFactureEnCours extends Component
{  
    use WithPagination;  
    protected $listeners = ['OpenModalFacture'];
    //public $list_data = [] ;
    public $ligne = 5 , $search , $journal ;



    public function OpenModalFacture($journal)
    {  
       // $this->list_data = Facture::getFactureEnCours($journal);
       $this->journal = $journal ;
        $this->dispatch('showModalFacture');
    }

    public function CloseModalFacture()
    {   
        $this->ligne = 5 ;
        $this->resetPage();
        $this->dispatch('hideModalFacture');
    }

    public function updatingLigne()
    {
        $this->resetPage();
    }

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function render()
    {   
        
        return view('livewire.modal-facture-en-cours',[
            'list_data' => Facture::where(['id_app' => get_id_app(), 'type_facture' => $this->journal])
                                    ->where('statut_facture','UNPAID')
                                    ->search($this->search)
                                    ->select('id','ref_facture','num_facture',
                                            'date_facture','intitule','montant',
                                            'solde','devise')
                                    ->paginate($this->ligne) 
            //(,$this->search,$this->ligne)
        ]);
    }
}
