<?php

namespace App\Livewire;

use App\Models\Transaction;
use Illuminate\Support\Facades\DB;
use Livewire\Component;

class ModalDetailTransaction extends Component
{   
    public  $title_detail , $list_data_detail = [] ;
    protected $listeners = ['showDetail'] ;

    public function showDetail(Transaction $transaction)
    {
        $this->title_detail = $transaction->intitule ;
        $this->list_data_detail = Transaction::showDetail($transaction->id);
        $this->dispatch('showModalDetailTransaction');  
    }


    public function render()
    {
        return view('livewire.modal-detail-transaction');
    }
}
