<?php

namespace App\Livewire;

use App\Models\Transaction;
use App\Rules\DateBetweenExercice;
use Livewire\Component;
use Illuminate\Support\Carbon;
use Livewire\WithPagination;


class JournauxComptable extends Component
{   
    use WithPagination ;
    public $date_start , $date_end, $journal ;
    public $title , $group ;
    public $title_detail , $ligne = 10  ;

    public function mount()
    {   
        //$value = session()->get('key');
        $exercice = getCurrentExercice() ;
        $this->date_start = isset($exercice->start_date)? $exercice->start_date : null ;
        $this->date_end   = isset($exercice->end_date)? $exercice->end_date : null ;
        $this->journal = (is_null(session()->get('journal')))? 'achat' : session()->get('journal') ;
       
    }

    public function searchJournal()
    {
        $this->validate([
            'journal' => ['required','string'],
            'date_start' => ['required','date','date_format:Y-m-d',new DateBetweenExercice,'after:2000-01-01'],
            'date_end' => ['required','date_format:Y-m-d',new DateBetweenExercice,'after_or_equal:date_start']
        ],[
            'journal.required' => 'obligatoire',
            'journal.string' => 'format text',
            'date_start.required' => 'obligatoire',
            'date_start.date' => 'format invalid',
            'date_start.date_format' => 'format invalid',
            'date_start.after' => 'date à partir de 01/01/2000',
            'date_end.required' => 'obligatoire',
            'date_end.date_format' => 'format invalid',
            'date_end.after_or_equal' => 'pas inferieure date1',
        ]);
    }

    public function OpenSaisieJournal()
    {   
        if($this->journal == "achat" ){
            to_route('journal-achat');
        }elseif($this->journal == "vente"){
            to_route('journal-vente');
        }elseif($this->journal == "od_av"){
            to_route('journal-od-achat-vente');
        }elseif($this->journal == "od"){
            to_route('journal-od');
        }elseif($this->journal == "banque"){
            to_route('journal-banque');
        }elseif($this->journal == "caisse"){
            to_route('journal-caisse');
        }else{
            $this->showToastr('failed|route not found. Contact admin please');
        }
      
    }


    public function get_Title_Search($journal,$date_start,$date_end)
    {
        switch ($journal){
            case 'achat' :
                $this->group = 'av' ;
                $this->title = "Journal des achats du ".get_format_date($date_start,'L')." au ".get_format_date($date_end,'L') ;
                break;
            case 'vente':
                $this->group = 'av';
                $this->title = "Journal des ventes du ".get_format_date($date_start,'L')." au ".get_format_date($date_end,'L') ;
                break;
            case 'banque' :
                $this->group = 'bc';
                $this->title = "Journal des banques du ".get_format_date($date_start,'L')." au ".get_format_date($date_end,'L') ;
                break;
            case 'caisse':
                $this->group = 'bc';
                $this->title = "Journal des caisses du ".get_format_date($date_start,'L')." au ".get_format_date($date_end,'L') ;
                break;
            case 'od_av':
                $this->group = 'od_av';
                $this->title = "Journal des OD Achats - ventes du ".get_format_date($date_start,'L')." au ".get_format_date($date_end,'L') ;
                break;
            default :
                $this->group = 'od';
                $this->title = "Journal des Operations diverses du ".get_format_date($date_start,'L')." au ".get_format_date($date_end,'L') ;
        }
    }



    public function render()
    {   
        $this->get_Title_Search($this->journal,$this->date_start,$this->date_end);
        return view('livewire.journaux-comptable',[
            'list_data' => get_journal_comptable($this->journal,$this->date_start,$this->date_end, $this->ligne) 
        ]);
    }
}
