<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Immobilisation as Immo;


class Immobilisation extends Component
{   
  
    use WithPagination; 
    protected $listeners = ['loadImmoTable' => '$refresh'];
    public $ListImmo, $ligne = 10 , $search ;


    public function editImmo($id){
        $this->dispatch('editImmobilisation',$id) ;
    }

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function render()
    {
        return view('livewire.immobilisation', [
            'ListImm' =>  Immo::where(['id_app' => get_id_app()])
                        ->search($this->search)
                        ->orderBy('id', 'DESC')
                        ->paginate($this->ligne) ,
        ]);
    }
}
