<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\site;
use App\Models\UpFile;
use Livewire\WithFileUploads;
use Exception;

class DemandeNew extends Component
{
    use WithFileUploads;
    public $site, $date_start, $heure_start, $date_end, $heure_end, $object, $content, $key_noms, $key_email, $key_phone, $list_site;
    public $MyArray_intervenant = [], $nbrIntervenant = 0, $lettre = [];

    public function showToastr($message)
    {
        return $this->dispatch(
            'showToast',
            message: $message
        );
    }

    public function mount()
    {
        $this->list_site = site::select('id', 'nom')->get();
        if ($this->list_site) {
            $this->site = $this->list_site[0]->id;
        }
    }


    public function saveDemande()
    {
        $validator = $this->validate([
            'site' => ['required',],
            'object' => ['required', 'string', 'min:3', 'max:250'],
            'lettre.*' => ['nullable', 'file', 'mimes:pdf', 'max:102400'],
            'date_start' => ['required', 'date', 'after:today'],
            'heure_start' => ['required'],
            'date_end' => ['required', 'date', 'after:today'],
            'heure_end' => ['required',],

            'content' => ['required', 'string', 'min:3', 'max:4000'],
            'MyArray_intervenant' => ['required', 'array'],

        ], [
            'site.required' => "obligatoire",
            'date_start.required' => "obligatoire",
            'heure_start.required' => "obligatoire",
            'date_end.required' => "obligatoire",
            'heure_end.required' => "obligatoire",
            'object.required' => "obligatoire",
            'content.required' => "obligatoire",
            'MyArray_intervenant.required' => "Aucun intervenant trouvé",
            'MyArray_intervenant.array' => "Aucun intervenant trouvé",
        ]);

        try {
            $file = null;
            $resp = save_demande($validator['site'], 'demande', $validator['date_start'], $validator['heure_start'], $validator['date_end'], $validator['heure_end'], $validator['object'], $validator['content'], null, null, $this->MyArray_intervenant);

            if ($resp) {

                if (!is_null($this->lettre)) {
                    foreach ($this->lettre as $photo) {
                        //  $photo->store('photos');
                        $file = $photo->store('doc_site/' . get_id_app(), 'public');
                        UpFile::create([
                            'fk_demande' => $resp,
                            'upload' => $file
                        ]);
                    }
                }
                $this->resetForm_demande();
                $this->resetItem_intervenant();

                $this->showToastr('success|Demande envoyée');
            } else {
                $this->showToastr('failed|une erreur est survenue');
            }
        } catch (Exception $e) {

            $this->showToastr('failed|une erreur est survenue ');
        }
    }

    public function resetForm_demande()
    {
        $this->resetValidation();
        $this->site  =
            $this->date_start =
            $this->heure_start =
            $this->date_end =
            $this->heure_end =
            $this->object =
            $this->content = null;
        $this->nbrIntervenant = 0;
        $this->MyArray_intervenant = [];
    }

    public function showModal()
    {
        return $this->dispatch('showModalIntervenant');
    }

    public function closeModal()
    {
        $this->resetItem_intervenant();
        return $this->dispatch('hideModalIntervenant');
    }


    public function addItem_intervenant()
    {

        $validator = $this->validate([
            'key_noms' => ['required', 'string', 'min:3', 'max:50'],
            'key_phone'  => ['nullable', 'numeric', 'min:10', 'max:9999999999999.99'],
            'key_email' => ['nullable', 'email'],
        ], [
            'key_noms.required' => "obligatoire",
            'key_noms.string'  => "invalide",
            'key_noms.min'      => "trop court",
            'key_noms.max'      => "trop long",

            'key_phone.numeric'  => "invalide",
            'key_phone.min'      => "min",
            'key_phone.max'      => "max",
            'key_email.email'      => "invalide"
        ]);

        $key = array_search(strtoupper(trim($validator['key_noms'])), array_column($this->MyArray_intervenant, 'noms'));

        if (is_int($key) && $key >= 0) {

            $this->showToastr('failed|ce nom existe déjà');
        } else {

            $array = array(
                'noms' => strtoupper(trim($validator['key_noms'])),
                'phone' => trim($validator['key_phone']),
                'email'     => trim($validator['key_email'])
            );

            array_push($this->MyArray_intervenant, $array);
            $this->nbrIntervenant = count($this->MyArray_intervenant);
            $this->resetItem_intervenant();
        }
    }

    public function removeItem_intervenant($noms)
    {

        $key = array_search($noms, array_column($this->MyArray_intervenant, 'noms'));
        unset($this->MyArray_intervenant[$key]);
        $ar = array();

        foreach ($this->MyArray_intervenant as $data):
            array_push($ar, $data);
        endforeach;

        $this->MyArray_intervenant = $ar;
        $this->nbrIntervenant = count($this->MyArray_intervenant);
    }

    public function resetItem_intervenant()
    {
        $this->key_noms =
            $this->key_phone  =
            $this->key_email =  null;
        $this->resetValidation();
    }


    public function render()
    {
        return view('livewire.demande-new');
    }
}
