<?php

namespace App\Livewire\Admin;

use App\Mail\WelcomeMessage;
use App\Models\Society;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Livewire\Component;


class ModalCustomer extends Component
{
    public $tab = null;
    public $activeBtnSave = false;
    public  $tab_t = 'society';
    protected $queryString = ['tab'];
    public  $isNewCustomer = true, $id;
    protected $listeners = ['NewSociety', 'editCustomer'];
    public $raison_sociale, $forme_sociale, $activite_principale, $phone_, $email_, $logo, $sigle, $adresse_,
        $ville_, $rue_, $pays_, $id_nat, $rccm, $num_impot;

    public $lastname, $firstname, $postname, $phone, $email, $pseudo, $user_id;
    public $current_password, $new_password, $new_password_confirmation;

    public function selectTab_t($tab_t)
    {
        $this->tab_t = $tab_t;
        // $this->resetValidation() ;
    }

    /*public function mount(){
        $this->tab = request()->tab ? request()->tab : $this->tabname ;
        //$this->type_t = $this->tab ;
    }*/

    public function CloseModalCustomer()
    {
        $this->resetForm();
        $this->dispatch('hideModalCustomer');
    }


    public function NewSociety()
    {
        $this->dispatch('showModalCustomer');
    }

    public function showToastr($message)
    {
        return $this->dispatch(
            'showToast',
            message: $message
        );
    }

    public function saveCustomer()
    {


        // 'unique:cpt_tbl_society,raison_sociale,'.get_id_app()

        $this->validate(
            [
                'raison_sociale'  => ['required'],
                'forme_sociale' => ['required', 'int'],
                'activite_principale' => ['nullable', 'string'],
                'phone_' => ['nullable', 'string'],
                'email_' => ['nullable', 'email'],
                'sigle' => ['nullable', 'string'],
                'adresse_'  => ['nullable', 'string'],
                'ville_' => ['nullable', 'string'],
                'pays_' => ['nullable', 'string'],
                'id_nat'  => ['nullable', 'string'],
                'rccm' => ['nullable', 'string'],
                'num_impot' => ['nullable', 'string'],

                'firstname'  => ['required', 'string'],
                'lastname'  => ['required', 'string'],
                'postname'  => ['nullable', 'string'],
                'phone'  => ['nullable', 'string'],
                'email'  => ['required', 'email'],
                'pseudo'  => ['required', 'string'],
            ],
            [
                'raison_sociale.required' => 'obligatoire',
                'forme_sociale.required' => 'obligatoire',
                'email_.email' => 'Email invalide',
                'firstname.required' => 'obligatoire',
                'lastname.required' => 'obligatoire',
                'email.required' => 'obligatoire',
                'email.email' => 'Email invalide',
                'pseudo.required' => 'obligatoire'
            ]
        );

        try {
            DB::beginTransaction();

            if ($this->isNewCustomer) {
                /** Generate Password */
                // $passWord = base64_encode(Str::random(7));
                $passWord = '123456';

                $this->StoreNewCustomer($passWord);
                $msg = "Création success";
            } else {
                $this->StoreUpdateCustomer($this->id);
                $msg = "Modification success";
            }
            $this->showToastr('success|' . $msg);
            DB::commit();

            /**
             * Send Mail 
             */
            if ($this->isNewCustomer) {
                $admin = (object) [
                    'raison_sociale' => $this->raison_sociale,
                    'firstname'  => $this->firstname,
                    'lastname'  => $this->lastname,
                    'email'  => $this->email,
                    'pseudo'  => $this->pseudo,
                    'password' => $passWord,
                ];
                $this->showToastr('success| Mail envoyé avec succès');

                /*  try {
                    Mail::to($this->email)->send(
                        new WelcomeMessage($admin)
                    );
        
                    //session()->flash('success','Un mail a été envoyé à '.$admin->email);
                    $this->showToastr('success| Mail envoyé avec succès');
                } catch (\Exception $e) {
                //Email sent failed.
                // session()->flash('fail','Echec d\'envoi du mail');
                // return redirect()->route('forgot-password');
                $this->showToastr('failed|Echec envoi Mail ' . $e);
                }
                */
            }
        } catch (\Exception $e) {
            DB::rollBack();
            $this->showToastr('failed|Une erreur est survenue');
        }
    }


    public function editCustomer(Society $society)
    {

        $this->resetForm();
        $user = User::where('id_app', $society->id)
            ->where('is_admin', 1)
            ->first();


        $this->fill([
            'raison_sociale'   => $society->raison_sociale,
            'forme_sociale' => $society->fk_id_forme_sociale,
            'activite_principale' => $society->activite_principale,
            'adresse_'  => $society->adresse,
            'email_'  => $society->email,
            'phone_'   => $society->telephone,
            'ville_'  => $society->ville,
            'pays_' =>  $society->pays,
            'sigle'  => $society->sigle,
            'id_nat'  => $society->identification_nat,
            'rccm'  => $society->num_rccm,
            'num_impot'  => $society->num_impot,
            'firstname'  => $user->firstname,
            'lastname'  => $user->lastname,
            'postname'  => $user->postname,
            'phone'  => $user->phone,
            'email'  => $user->email,
            'pseudo'  => $user->pseudo,
        ]);

        $this->id = $society->id;
        $this->user_id = $user->id;
        $this->isNewCustomer = false;
        $this->dispatch('showModalCustomer');
    }

    public function StoreNewCustomer($passWord)
    {

        $society = Society::create([
            'raison_sociale'   => $this->raison_sociale,
            'fk_id_forme_sociale' => $this->forme_sociale,
            'activite_principale' => $this->activite_principale,
            'adresse'  => $this->adresse_,
            'email'  => $this->email_,
            'phone'   => $this->phone_,
            'ville'  => $this->ville_,
            'pays' =>  $this->pays_,
            'sigle'  => $this->sigle,
            'identification_nat'  => $this->id_nat,
            'num_rccm'  => $this->rccm,
            'num_impot'  => $this->num_impot,
            'user_crea' => get_pseudo()
        ]);



        /** Insert User a compte  */
        User::create([
            'pseudo' => $this->pseudo,
            'firstname' => $this->firstname,
            'lastname'  => $this->lastname,
            'postname' => $this->postname,
            'phone'  => $this->phone,
            'email' => $this->email,
            'password' => Hash::make($passWord),
            'role_user_id' => 1,
            'is_admin' => 1,
            'id_app' => $society->id,
            'user_crea' => get_pseudo()
        ]);
    }

    public function StoreUpdateCustomer()
    {
        $society = Society::findOrFail($this->id);
        // $society->raison_sociale = $this->raison_sociale ;
        // $society->fk_id_forme_sociale = $this->forme_sociale;
        $society->activite_principale =  $this->activite_principale;
        $society->telephone = $this->phone;
        $society->email = $this->email_;
        $society->sigle = $this->sigle;
        $society->adresse = $this->adresse_;
        $society->ville = $this->ville_;
        $society->pays =  $this->pays_;
        $society->identification_nat = $this->id_nat;
        $society->num_rccm = $this->rccm;
        $society->num_impot =  $this->num_impot;
        $society->user_crea = get_pseudo();
        $society->save();

        $user = User::findOrFail($this->user_id);

        $user->fill([
            'firstname' => $this->firstname,
            'lastname'  => $this->lastname,
            'postname' => $this->postname,
            'phone'  => $this->phone,
        ]);
        $user->save();
    }

    public function resetForm()
    {

        $this->raison_sociale =
            $this->forme_sociale =
            $this->activite_principale =
            $this->phone_ =
            $this->email_ =
            $this->adresse_ =
            $this->ville_ =
            $this->sigle =
            $this->pays_ =
            $this->id_nat =
            $this->rccm =
            $this->num_impot = null;
        $this->isNewCustomer = true;

        $this->lastname =
            $this->firstname =
            $this->postname =
            $this->phone =
            $this->email =
            $this->pseudo =
            $this->user_id =
            $this->id =
            $this->new_password =
            $this->new_password_confirmation = null;
        //$this->resetItem();
    }

    public function render()
    {
        return view('livewire.admin.modal-customer');
    }
}
