<?php

namespace App\Livewire\Admin;

use App\Models\Rens;
use Livewire\Component;
use Livewire\WithPagination;

class GestionDemandeRens extends Component
{
    use WithPagination;

    public $per_page = 10, $search;


    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function detailRens(Rens $rens)
    {

        $this->dispatch('showModalDetailRens');
    }

    public function render()
    {
        return view('livewire.admin.gestion-demande-rens', [
            'lists' => Rens::search($this->search)
                ->orderBy('created_at', 'DESC')
                ->paginate($this->per_page)
        ]);
    }
}
