<?php

namespace App\Livewire\Admin;

use Livewire\Component;
use App\Models\intervenant;
use App\Models\traitement;
use Exception;
use Livewire\WithPagination;

class GestionDemande extends Component
{
    use WithPagination;
    public $typeDemande, $listDemande, $OptionDemande = [], $itemActif = null;
    protected $listeners = [
        'resetGestDemande' => 'initGestDemande'
    ];

    private $OptionDemande1 = [
        ['idx' => 'NL', 'lib' => 'Non lues'],
        ['idx' => 'NT', 'lib' => 'En attente'],
        ['idx' => 'DA', 'lib' => 'Acceptées'],
        ['idx' => 'DR', 'lib' => 'Refusées'],
        ['idx' => 'DE', 'lib' => 'Expirées']
    ];
    private $OptionDemande2 = [
        ['idx' => 'NT', 'lib' => 'En attente'],
        ['idx' => 'DA', 'lib' => 'Acceptées'],
        ['idx' => 'DR', 'lib' => 'Refusées'],
        ['idx' => 'DE', 'lib' => 'Expirées']
    ];


    public function mount()
    {
        $this->typeDemande = 'PENDING';
        $this->listDemande = get_group_demande();
    }

    private function setTypeDemande()
    {
        switch ($this->typeDemande) {
            case 'NT':
                return 'PENDING';
            case 'DA':
                return 'ALLOWED';
            case 'DR':
                return 'REJECTED';
            case 'DE':
                return 'EXPIRED';
            default:
                return NULL;
        }
    }

    private function setOptionDemande()
    {
        $type = $this->typeDemande;

        if ($type === "NL" || $type === "NT" || is_null($type)) {
            if (get_list_demande(NULL)) {
                $this->OptionDemande = $this->OptionDemande1;
                $this->typeDemande = "NL";
            } else {
                $this->OptionDemande = $this->OptionDemande2;
                $this->typeDemande = "NT";
            }
        }
    }

    /*  private function getDemande($key)
    {
        //$this->resetPage();
        $this->demande = get_demande($key);
        if ($this->demande) {
            try {
                $this->listIntervenants = get_intervenants($key);
                traitement::create([
                    'fk_demande' => $key,
                    'user_crea' => get_pseudo(),
                ]);
            } catch (Exception $e) {
                //dd($e);
            }
        }
    }*/

    public function initGestDemande()
    {
        $this->listDemande = get_group_demande();
    }
    /*
    public function updatedTypeDemande()
    {

        $this->itemActif = null;
        // $this->demande = null;
        // $this->listIntervenants = [];
        $this->dispatch('resetDemande');
        $this->listDemande = get_list_demande($this->setTypeDemande());
    }
    */
    public function vieWDemande($key)
    {
        //$this->resetPage();
        $this->typeDemande = $key;
        $this->dispatch('viewDemande', $key);
    }

    public function render()
    {
        return view('livewire.admin.gestion-demande');
    }
}
