<?php

namespace App\Http\Controllers;

use Exception;
use constDefaults;
use App\Models\User;
use App\Mail\ResetPassword;
use Illuminate\Support\Str;
use App\Mail\ForgotPassword;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;


class LoginController extends Controller
{
    public function loginHandler(Request $request){
       
        $fieldType = filter_var($request->login_id,FILTER_VALIDATE_EMAIL) ? 'email' : 'pseudo';

        if($fieldType === 'email'){

            $request->validate([
                'login_id' => ['required','email','exists:users,email'],
                'password' => ['required']
            ],
            [
                'login_id.required' => 'Username ou Email requis',
                'login_id.email'   => 'Email invalid',
                'login_id.exists'  => 'Email n\'existe pas ',
                'password' =>  'Mot de passe est requis',
            ]);

        }else{

            $request->validate([
                'login_id' => ['required','exists:users,pseudo'],
                'password' => ['required']
            ],
            [
                'login_id.required' => 'Username ou Email requis',
                'login_id.exists'  => 'Username n\'existe pas',
                'password' => 'Mot de passe est requis',
            ]);
        }


        $creds = array(
            $fieldType => $request->login_id,
            'password' => $request->password
        );

        if(Auth::attempt($creds)){
            $request->session()->regenerate();
            setExercice(getLastOpenExercice());
            if(get_id_app() == 0){
                return redirect()->intended(route('admin.home'));
            }
            return redirect()->intended(route('home'));
        }else{
            session()->flash('fail','Identifiants incorrect');
            return redirect()->route('login')->onlyInput('login_id');
        }
    }

    public function logoutHandler(){
        
        Auth::logout();
        session()->flash('fail','vous êtes déconnecté');
        return redirect()->route('login');
    }

    public function sendPasswordResetLink(Request $request){

        $request->validate([
            'email' => ['required','email','exists:users,email'],
        ],
        [
            'email.required' => 'Email requis',
            'email.email'  => 'Email invalid',
            'email.exists'  => 'cette Email n\'existe pas'
           
        ]);

        //Get email detail
        $admin = User::where('email',$request->email)->first();

        //Generate token
        $token = base64_encode(Str::random(65));

        // check if there is an existing reset password token
        $oldToken = DB::table('password_reset_tokens')
                            ->where(['email' => $request->email])
                            ->first();

        if($oldToken){
            //update
            DB::table('password_reset_tokens')
                    ->where(['email' => $request->email])
                    ->update([
                        'token' => $token,
                        'created_at' => Carbon::now()
                    ]);
        }else{
            // add new token
            DB::table('password_reset_tokens')
                ->insert([
                'email' => $request->email,
                'token' => $token,
                'created_at' => Carbon::now()
                ]);
        }


        $actionLink = route('reset-password',['token' => $token]);
        

        try {
            Mail::to($admin->email)->send(
                new ForgotPassword($admin,$actionLink)
            );

            session()->flash('success','Un mail a été envoyé à '.$admin->email);
            return redirect()->route('forgot-password');
        } catch (Exception $e) {
          //Email sent failed.
            session()->flash('fail','Echec d\'envoi du mail');
            return redirect()->route('forgot-password');
        }

    }
 
   public function resetPassword(Request $request, $token = null){

        $check_token = DB::table('password_reset_tokens')
                ->where(['token' => $token])
                ->first();

            if($check_token){
                // check if token not expired

                $diffMins = Carbon::createFromFormat('Y-m-d H:i:s',$check_token->created_at)
                            ->diffInMinutes(Carbon::now());
                
                if($diffMins > constDefaults::tokenExpiredMinutes){
                    session()->flash('fail','Lien expiré !. veuillez demander à nouveau');
                    return redirect()->route('forgot-password',['token' => $token]);
                }else{
                    return view('pages.auth.reset-password',['token' => $token]);
                }
                 
            }else{
                session()->flash('fail','Lien expiré ! veuillez demander à nouveau');
                return redirect()->route('forgot-password',['token' => $token]);
            }

    }


    public function resetPasswordHandler(Request $request){

        $request->validate([
            'new_password' => ['required',
                                'string',
                                'min:8','regex:/[A-Z]/','regex:/[a-z]/',
                                'regex:/[0-9]/','regex:/[_!@#$%^&*()<>?,;]/',
                                'required_with:confirmation_password',
                                'same:confirmation_password'],
            'confirmation_password' => ['required'],
            'private_token' => ['required','exists:password_reset_tokens,token']
        ],
        [
           'new_password.regex' => 'Le Password doit contenir Minuscules,Majuscules, Chiffres et Catectères : _!@#$%^&*()<>?,;' 
        ]);

        $token = DB::table('password_reset_tokens')
            ->where(['token' => $request->private_token ])
            ->first();
        
        if($token){
        
        //Get admin details
        $admin = User::where('email',$token->email)->first();

        //Update admin password
        User::where('email',$admin->email)->update([
            'password' => Hash::make($request->new_password)
        ]);

        //Delete token record
        DB::table('password_reset_tokens')
            ->where(['email' => $admin->email ,
                    'token' => $token->token 
        ])->delete();
         
        //send email to Notify user
      

        Mail::to($admin->email)
            ->later(now()->addMinutes(5), new ResetPassword('Reset Password',$admin));

    
        return redirect()->route('login')->with('success','Mot de passe mis à jour !. Connectez-vous');

        }else{

            session()->flash('fail','Lien non trouvé !. veuillez demander à nouveau');
            return redirect()->route('forgot-password');
 
        }
    }

    public function changeProfilePicture(Request $request)
    {

        dd(1111);
       /* $admin = Admin::findOrFail(auth('admin')->id());
        $path = 'images/users/';
        $file = $request->file('adminProfilePictureFile');
        $old_picture =$admin->getAttribute()['picture'];
        $file_path = $path.$old_picture ;
        $filename = 'img_'.rand(2,1000).$admin->id.time().uniqid().'.jpg';
        $upload = $file->move(public_path($path),$filename);

        if($upload){
                if($old_picture != null && File::exits(public_path($path.$old_picture)))
                {
                    File::delete(public_path(($path.$old_picture)));
                }
                $admin->update(['update' => $filename]);
                return response()->json(['status' =>1,'msg' => ' Upload effectué ']);
        }else{
            return response()->json(['status' =>0,'msg' => 'un probleme d\'upload ']);
        }*/


   // return response()->json(['status' =>0,'msg' => 'un probleme d\'upload ']);

    }

   /* public function profileView(){
         $admin = null ;
         if(Auth::guard('admin')->check()){
            $admin = Admin::findOrFail(auth()->id());
         }

        return view('back.pages.admin.profileView',compact('admin'));
    }*/
}
